/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.internal;

import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExtractorBuilder;
import com.tangosol.coherence.dslquery.internal.AbstractCoherenceQueryWalker;
import com.tangosol.coherence.dslquery.operator.BaseOperator;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.CompositeAggregator;
import com.tangosol.util.aggregator.DistinctValues;
import com.tangosol.util.aggregator.GroupAggregator;
import com.tangosol.util.aggregator.ReducerAggregator;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.processor.CompositeProcessor;
import com.tangosol.util.processor.ExtractorProcessor;
import java.util.List;

public class SelectListMaker
extends AbstractCoherenceQueryWalker {
    protected String m_sCacheName;
    protected NodeTerm m_term;
    protected int m_nCallCount = 0;
    protected Object[] m_aResults;

    public SelectListMaker(List indexedBindVars, ParameterResolver namedBindVars, CoherenceQueryLanguage language) {
        super(indexedBindVars, namedBindVars, language);
    }

    public boolean hasCalls() {
        return this.m_nCallCount > 0;
    }

    public boolean isAggregation() {
        return this.m_nCallCount == this.m_aResults.length;
    }

    public Object[] getResults() {
        return this.m_aResults;
    }

    public ValueExtractor getResultsAsValueExtractor() {
        if (this.hasCalls() || this.m_aResults.length == 0) {
            return null;
        }
        if (this.m_aResults.length == 1) {
            return (ValueExtractor)this.m_aResults[0];
        }
        ValueExtractor[] extractors = new ValueExtractor[this.m_aResults.length];
        for (int i = 0; i < this.m_aResults.length; ++i) {
            extractors[i] = (ValueExtractor)this.m_aResults[i];
        }
        return new MultiExtractor(extractors);
    }

    public DistinctValues getDistinctValues() {
        if (this.hasCalls()) {
            return null;
        }
        return new DistinctValues(this.getResultsAsValueExtractor());
    }

    public InvocableMap.EntryProcessor getResultsAsEntryProcessor() {
        if (this.hasCalls()) {
            return null;
        }
        if (this.m_aResults.length == 1) {
            return new ExtractorProcessor((ValueExtractor)this.m_aResults[0]);
        }
        InvocableMap.EntryProcessor[] processors = new InvocableMap.EntryProcessor[this.m_aResults.length];
        for (int i = 0; i < this.m_aResults.length; ++i) {
            processors[i] = new ExtractorProcessor((ValueExtractor)this.m_aResults[i]);
        }
        return new CompositeProcessor(processors);
    }

    public InvocableMap.EntryAggregator getResultsAsReduction() {
        int nIdentifierCount = this.m_aResults.length;
        if (this.hasCalls()) {
            return null;
        }
        if (nIdentifierCount == 1) {
            return new ReducerAggregator((ValueExtractor)this.m_aResults[0]);
        }
        ValueExtractor[] aExtractors = new ValueExtractor[nIdentifierCount];
        for (int i = 0; i < nIdentifierCount; ++i) {
            aExtractors[i] = (ValueExtractor)this.m_aResults[i];
        }
        return new ReducerAggregator(new MultiExtractor(aExtractors));
    }

    public InvocableMap.EntryAggregator getResultsAsEntryAggregator() {
        InvocableMap.EntryAggregator aggregator;
        int nIdentifierCount = this.m_aResults.length - this.m_nCallCount;
        if (!this.hasCalls()) {
            return null;
        }
        if (this.m_aResults.length == 1) {
            return (InvocableMap.EntryAggregator)this.m_aResults[0];
        }
        if (this.m_aResults.length == this.m_nCallCount) {
            InvocableMap.EntryAggregator[] aAggregators = new InvocableMap.EntryAggregator[this.m_aResults.length];
            for (int i = 0; i < this.m_aResults.length; ++i) {
                aAggregators[i] = (InvocableMap.EntryAggregator)this.m_aResults[i];
            }
            return CompositeAggregator.createInstance(aAggregators);
        }
        ValueExtractor[] aExtractors = new ValueExtractor[nIdentifierCount];
        for (int i = 0; i < nIdentifierCount; ++i) {
            aExtractors[i] = (ValueExtractor)this.m_aResults[i];
        }
        if (this.m_nCallCount == 1) {
            aggregator = (InvocableMap.EntryAggregator)this.m_aResults[nIdentifierCount];
        } else {
            InvocableMap.EntryAggregator[] aAggregators = new InvocableMap.EntryAggregator[this.m_nCallCount];
            for (int i = 0; i < this.m_nCallCount; ++i) {
                aAggregators[i] = (InvocableMap.EntryAggregator)this.m_aResults[nIdentifierCount + i];
            }
            aggregator = CompositeAggregator.createInstance(aAggregators);
        }
        if (nIdentifierCount == 1) {
            return GroupAggregator.createInstance(aExtractors[0], aggregator);
        }
        return GroupAggregator.createInstance(new MultiExtractor(aExtractors), aggregator);
    }

    public Object[] makeSelectsForCache(String sCacheName, NodeTerm term) {
        this.m_sCacheName = sCacheName;
        this.m_term = term;
        this.m_aResults = new Object[this.m_term.length()];
        int nCount = this.m_term.length();
        this.setResult(null);
        for (int i = 1; i <= nCount; ++i) {
            this.m_term.termAt(i).accept(this);
            this.m_aResults[i - 1] = this.getResult();
        }
        return this.m_aResults;
    }

    @Override
    protected void acceptBinaryOperator(String sOperator, Term termLeft, Term termRight) {
        BaseOperator operator = this.f_language.getOperator(sOperator);
        this.setResult(operator.makeExtractor(termLeft, termRight, this));
    }

    @Override
    protected void acceptCall(String sFunctionName, NodeTerm term) {
        super.acceptCall(sFunctionName, term);
        Object oResult = this.getResult();
        if (oResult instanceof InvocableMap.EntryAggregator) {
            ++this.m_nCallCount;
        }
    }

    @Override
    protected void acceptIdentifier(String sIdentifier) {
        if (this.acceptIdentifierInternal(sIdentifier)) {
            return;
        }
        ExtractorBuilder builder = this.f_language.getExtractorBuilder();
        this.setResult(builder.realize(this.m_sCacheName, 0, sIdentifier));
    }

    @Override
    protected void acceptPath(NodeTerm term) {
        this.acceptPathAsChainedExtractor(this.m_sCacheName, term);
    }
}

