/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.util.List;

public class ExtendedLanguageStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    @Override
    public ExtendedLanguageQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        AtomicTerm action = (AtomicTerm)term.termAt(1);
        if ("on".equals(action.getValue())) {
            return new ExtendedLanguageQueryPlusStatement(true);
        }
        if ("off".equals(action.getValue())) {
            return new ExtendedLanguageQueryPlusStatement(false);
        }
        throw new CohQLException("Invalid extended language command - valid syntax is: " + this.getSyntax());
    }

    @Override
    public String getSyntax() {
        return "EXTENDED LANGUAGE (ON | OFF)";
    }

    @Override
    public String getDescription() {
        return "Controls extended language mode.";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new ExtendedLanguageCommandOPToken();
    }

    public class ExtendedLanguageQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        protected boolean m_fExtended;

        protected ExtendedLanguageQueryPlusStatement(boolean fExtended) {
            this.m_fExtended = fExtended;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.setExtendedLanguage(this.m_fExtended);
            return StatementResult.NULL_RESULT;
        }
    }

    public class ExtendedLanguageCommandOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public ExtendedLanguageCommandOPToken() {
            super("extended", OPToken.IDENTIFIER_NODE, "extendedLanguageCommand");
        }

        @Override
        public Term nud(OPParser parser) {
            OPScanner scanner = parser.getScanner();
            scanner.advanceWhenMatching("language");
            String action = scanner.getCurrentAsStringWithAdvance();
            return Terms.newTerm(this.getFunctor(), AtomicTerm.createString(action));
        }
    }
}

