/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.util.List;

public class WheneverStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    @Override
    public WheneverQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        AtomicTerm action = (AtomicTerm)term.termAt(1);
        String sValue = action.getValue();
        if ("continue".equalsIgnoreCase(sValue)) {
            return new WheneverQueryPlusStatement(false);
        }
        if ("exit".equalsIgnoreCase(sValue)) {
            return new WheneverQueryPlusStatement(true);
        }
        throw new CohQLException("Invalid whenever command - valid syntax is: " + this.getSyntax());
    }

    @Override
    public String getSyntax() {
        return "WHENEVER COHQLERROR THEN (CONTINUE | EXIT)";
    }

    @Override
    public String getDescription() {
        return "Controls the action taken by QueryPlus when a statement fails to execute.";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new WheneverCommandOPToken();
    }

    public class WheneverQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        protected boolean m_fStopOnError;

        protected WheneverQueryPlusStatement(boolean fStopOnError) {
            this.m_fStopOnError = fStopOnError;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.setStopOnError(this.m_fStopOnError);
            return StatementResult.NULL_RESULT;
        }
    }

    public class WheneverCommandOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public WheneverCommandOPToken() {
            super("whenever", OPToken.IDENTIFIER_NODE, "wheneverCommand");
        }

        @Override
        public Term nud(OPParser parser) {
            OPScanner scanner = parser.getScanner();
            scanner.advanceWhenMatching("cohqlerror");
            scanner.advanceWhenMatching("then");
            String sAction = scanner.getCurrentAsStringWithAdvance();
            return Terms.newTerm(this.getFunctor(), AtomicTerm.createString(sAction));
        }
    }
}

