/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.util.MapBackupHelper;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.NullImplementation;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.List;

public class RestoreStatementBuilder
extends AbstractStatementBuilder<RestoreStatement> {
    public static final RestoreStatementBuilder INSTANCE = new RestoreStatementBuilder();

    @Override
    public RestoreStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = RestoreStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed to restore cache");
        }
        String sFile = RestoreStatementBuilder.getFile(term);
        if (sFile == null || sFile.isEmpty()) {
            throw new CohQLException("File name needed to restore cache");
        }
        return new RestoreStatement(sCacheName, sFile);
    }

    @Override
    public String getSyntax() {
        return "RESTORE CACHE 'cache-name' [FROM] [FILE] 'filename'";
    }

    @Override
    public String getDescription() {
        return "Restore the cache named 'cache-name' from the file named 'filename'.\nWARNING: This restore command should not be used on active data set, as it makes\nno provisions that ensure data consistency during the restore. Please see the\ndocumentation for more detailed information.\nNote: As of Coherence 12.2.1 this command is deprecated. Please use Persistence\ncommand 'RECOVER SNAPSHOT' instead.";
    }

    public static class RestoreStatement
    extends AbstractStatement {
        protected final String f_sCacheName;
        protected final String f_sFile;

        public RestoreStatement(String sCacheName, String sFile) {
            this.f_sCacheName = sCacheName;
            this.f_sFile = sFile;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            try (RandomAccessFile file = new RandomAccessFile(new File(this.f_sFile), "rw");){
                NamedCache cache = ctx.getCacheFactory().ensureTypedCache(this.f_sCacheName, NullImplementation.getClassLoader(), TypeAssertion.withoutTypeChecking());
                MapBackupHelper.readMap(file, cache, 0, null);
            }
            catch (IOException e) {
                throw RestoreStatement.ensureRuntimeException(e, "Error in RESTORE");
            }
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("ExternalizableHelper.readMap(new RandomAccessFile(new File(\"%s\"),\"rw\"),CacheFactory.getCache(\"%s\"), null)", this.f_sFile, this.f_sCacheName);
        }
    }
}

