/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.SelectListMaker;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;

public class SelectStatementBuilder
extends AbstractStatementBuilder<SelectStatement> {
    public static final SelectStatementBuilder INSTANCE = new SelectStatementBuilder();

    @Override
    public SelectStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        SelectListMaker transformer = this.createSelectListMaker(listBindVars, namedBindVars, ctx.getCoherenceQueryLanguage());
        String sCacheName = SelectStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for select query");
        }
        boolean isDistinct = SelectStatementBuilder.getIsDistinct(term);
        String alias = SelectStatementBuilder.getAlias(term);
        NodeTerm fields = SelectStatementBuilder.getFields(term);
        NodeTerm whereTerm = SelectStatementBuilder.getWhere(term);
        NodeTerm groupBy = SelectStatementBuilder.getGroupBy(term);
        if (groupBy != null) {
            if (fields == null) {
                throw new CohQLException("must have fields for group by to make sense");
            }
            if (!SelectStatementBuilder.headsMatch(fields, groupBy)) {
                throw new CohQLException("group by fields must match head of select list");
            }
        }
        InvocableMap.EntryAggregator aggregator = this.createAggregator(sCacheName, fields, alias, isDistinct, transformer);
        Filter filter = SelectStatementBuilder.ensureFilter(whereTerm, sCacheName, alias, listBindVars, namedBindVars, ctx);
        boolean fReduction = !transformer.hasCalls() && !isDistinct && aggregator != null;
        return new SelectStatement(sCacheName, filter, aggregator, fReduction);
    }

    @Override
    public String getSyntax() {
        return "SELECT (properties* aggregators* | * | alias) FROM 'cache-name' [[AS] alias]\n        [WHERE conditional-expression] [GROUP [BY] properties+]";
    }

    @Override
    public String getDescription() {
        return "Select an ordered list of properties from the cache named 'cache-name' filtered\nby the conditional-expression. If '*' is used then fetch the entire object.\nIf no conditional-expression is given all elements are selected, so this is not\nsuggested for large data sets!\n\nSELECT aggregators FROM 'cache-name' [[AS] alias] [WHERE conditional-expression]\n\nSelect an ordered list of aggregators from the cache named 'cache-name' selected\nby the conditional-expression.\nThe aggregators may be MAX, MIN, AVG, SUM, COUNT, LONG_MAX, LONG_MIN, LONG_SUM.\nIf no conditional-expression is given all elements are selected.\n\nSELECT (properties then aggregators) FROM 'cache-name' [[AS] alias]\n        [WHERE conditional-expression ] GROUP [BY] properties\n\nSelect an ordered list of properties aggregators from the cache named\n'cache-name' selected by the conditional-expression and grouped by the\nset of properties that precedes the aggregators. For example:\n    SELECT supplier, SUM(amount), AVG(price) FROM 'orders' GROUP BY supplier\nAs usual, if no conditional-expression is given all elements are selected.";
    }

    protected InvocableMap.EntryAggregator createAggregator(String cacheName, NodeTerm fields, String alias, boolean fDistinct, SelectListMaker transformer) {
        InvocableMap.EntryAggregator aggregator = null;
        if (!this.isSelectStarQuery(alias, fields)) {
            transformer.setAlias(alias);
            transformer.makeSelectsForCache(cacheName, fields);
            aggregator = !transformer.hasCalls() ? (fDistinct ? transformer.getDistinctValues() : transformer.getResultsAsReduction()) : transformer.getResultsAsEntryAggregator();
        }
        return aggregator;
    }

    protected SelectListMaker createSelectListMaker(List listBindVars, ParameterResolver namedBindVars, CoherenceQueryLanguage language) {
        return new SelectListMaker(listBindVars, namedBindVars, language);
    }

    protected boolean isSelectStarQuery(String sAlias, NodeTerm termFields) {
        return termFields.termEqual(Terms.newTerm("fieldList", AtomicTerm.createString("*"))) || sAlias != null && termFields.termEqual(Terms.newTerm("fieldList", AtomicTerm.createString(sAlias)));
    }

    public static class SelectStatement
    extends AbstractStatement {
        protected final String f_sCache;
        protected final Filter f_filter;
        protected final InvocableMap.EntryAggregator f_aggregator;
        protected final boolean f_fReduction;

        public SelectStatement(String sCache, Filter filter, InvocableMap.EntryAggregator aggregator, boolean fReduction) {
            this.f_sCache = sCache;
            this.f_filter = filter;
            this.f_aggregator = aggregator;
            this.f_fReduction = fReduction;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            NamedCache cache = ctx.getCacheFactory().ensureTypedCache(this.f_sCache, null, TypeAssertion.withoutTypeChecking());
            Set oResult = this.f_aggregator == null ? cache.entrySet(this.f_filter) : cache.aggregate(this.f_filter, this.f_aggregator);
            return new DefaultStatementResult(oResult, !this.f_fReduction);
        }

        @Override
        public void showPlan(PrintWriter out) {
            if (this.f_aggregator == null) {
                out.printf("CacheFactory.getCache(\"%s\").entrySet(%s)", this.f_sCache, this.f_filter);
            } else {
                out.printf("CacheFactory.getCache(\"%s\").aggregate(%s, %s)", this.f_sCache, this.f_filter, this.f_aggregator);
            }
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCache, ctx);
        }

        public Filter getFilter() {
            return this.f_filter;
        }

        public InvocableMap.EntryAggregator getAggregator() {
            return this.f_aggregator;
        }
    }
}

