/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.List;

public class SourceStatementBuilder
extends AbstractStatementBuilder<SourceStatement> {
    public static final SourceStatementBuilder INSTANCE = new SourceStatementBuilder();

    @Override
    public SourceStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sFile = SourceStatementBuilder.getFile(term);
        if (sFile == null || sFile.isEmpty()) {
            throw new CohQLException("File name needed for sourcing");
        }
        return new SourceStatement(sFile);
    }

    @Override
    public String getSyntax() {
        return "SOURCE FROM [FILE] 'filename'\n@ 'filename'\n. filename";
    }

    @Override
    public String getDescription() {
        return "Read and process a file of commands form the file named 'file-name. Each\nstatement must end with a ';'. The character '@' may be used as an alias for\nSOURCE FROM [FILE] as in @ 'filename'. Source files may SOURCE other files.\nAt the command line only you may also use '.' as an abbreviation for '@' but\ndo not put quotes around the filename since '.' is processed specially before\nthe line executed.";
    }

    public static class SourceStatement
    extends AbstractStatement {
        protected final String f_sFileName;

        public SourceStatement(String sFileName) {
            this.f_sFileName = sFileName;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            return this.source(this.f_sFileName, ctx);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("source('%s')", this.f_sFileName);
        }

        @Override
        public boolean isManagingTimeout() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatementResult source(String sFileName, ExecutionContext ctx) {
            BufferedReader reader;
            if (sFileName == null || sFileName.length() == 0) {
                return StatementResult.NULL_RESULT;
            }
            try {
                reader = new BufferedReader(new FileReader(sFileName));
            }
            catch (FileNotFoundException e) {
                String sError = "file not found " + sFileName;
                if (ctx.isStopOnError()) {
                    throw new CohQLException(sError);
                }
                this.traceout(sError, ctx.getWriter(), ctx.isTraceEnabled());
                return StatementResult.NULL_RESULT;
            }
            boolean fSavedSilent = ctx.isSilent();
            boolean fSavedSanity = ctx.isSanityChecking();
            ctx.setSilentMode(true);
            try {
                ctx.getStatementExecutor().execute(reader, ctx);
            }
            finally {
                ctx.setSilentMode(fSavedSilent);
                ctx.setSanityCheckingEnabled(fSavedSanity);
            }
            return StatementResult.NULL_RESULT;
        }

        protected void traceout(String sLine, PrintWriter writer, boolean fTrace) {
            if (fTrace && writer != null) {
                writer.println(sLine);
            }
        }
    }
}

