/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.io.FileHelper;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public abstract class AbstractSnapshotStatement
extends AbstractStatement {
    protected static final String SUCCESS = "Success";
    public static final SimpleDateFormat MONTH_NAME = new SimpleDateFormat("MMMM");
    public static final SimpleDateFormat WEEKDAY_NAME = new SimpleDateFormat("E");
    protected final String f_sSnapshotName;
    protected final String f_sServiceName;

    public AbstractSnapshotStatement(String sSnapshotName, String sServiceName) {
        this.f_sSnapshotName = sSnapshotName;
        this.f_sServiceName = sServiceName;
    }

    @Override
    public void showPlan(PrintWriter out) {
    }

    protected String getConfirmationMessage(String sAction) {
        return "Are you sure you want to " + sAction + " a snapshot called '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'? (y/n): ";
    }

    protected void validateSnapshotName(String sSnapshotName) throws CohQLException {
        String sSafeSnapshotName = FileHelper.toFilename(sSnapshotName);
        if (!sSafeSnapshotName.equals(sSnapshotName)) {
            throw new CohQLException("The supplied snapshot name " + sSnapshotName + " is not a valid file name. Consider using " + sSafeSnapshotName);
        }
    }

    protected void validateServiceExists(PersistenceToolsHelper helper) {
        if (!helper.serviceExists(this.f_sServiceName)) {
            throw new CohQLException("Service '" + this.f_sServiceName + "' does not exist");
        }
    }

    protected void validateSnapshotExistsForService(PersistenceToolsHelper helper) {
        if (!helper.snapshotExists(this.f_sServiceName, this.f_sSnapshotName)) {
            throw new CohQLException("Snapshot '" + this.f_sSnapshotName + "' does not exist for service '" + this.f_sServiceName + "'");
        }
    }

    protected void validateArchivedSnapshotExistsForService(PersistenceToolsHelper helper) {
        if (!helper.archivedSnapshotExists(this.f_sServiceName, this.f_sSnapshotName)) {
            throw new CohQLException("Snapshot '" + this.f_sSnapshotName + "' does not exist for service '" + this.f_sServiceName + "'");
        }
    }

    protected static String replaceDateMacros(String sSnapshotName) {
        String sFinalName = new String(sSnapshotName);
        Calendar calendar = Calendar.getInstance();
        sFinalName = sFinalName.replaceAll("%mm", String.format("%02d", calendar.get(12))).replaceAll("%m", String.format("%02d", calendar.get(2))).replaceAll("%y", String.format("%d", calendar.get(1))).replaceAll("%d", String.format("%02d", calendar.get(5))).replaceAll("%hh", String.format("%02d", calendar.get(11))).replaceAll("%w", WEEKDAY_NAME.format(calendar.getTime())).replaceAll("%M", MONTH_NAME.format(calendar.getTime()));
        return sFinalName;
    }
}

