/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class ResumeServiceStatementBuilder
extends AbstractStatementBuilder<ResumeServiceStatement> {
    public static final ResumeServiceStatementBuilder INSTANCE = new ResumeServiceStatementBuilder();

    @Override
    public ResumeServiceStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = ResumeServiceStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for resume service");
        }
        return new ResumeServiceStatement(sServiceName == null || sServiceName.isEmpty() ? null : sServiceName);
    }

    @Override
    public String getSyntax() {
        return "RESUME SERVICE 'service'";
    }

    @Override
    public String getDescription() {
        return "Resume a previously suspended service. \nNote: If the service is not suspended, this is a No-op.";
    }

    public static class ResumeServiceStatement
    extends AbstractStatement {
        private final String f_sServiceName;

        public ResumeServiceStatement(String sServiceName) {
            this.f_sServiceName = sServiceName;
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return "Are you sure you want to resume the service '" + this.f_sServiceName + "'? (y/n): ";
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                if (!helper.serviceExists(this.f_sServiceName)) {
                    throw new CohQLException("Service '" + this.f_sServiceName + "' does not exist");
                }
                out.println("Resuming service '" + this.f_sServiceName + "'");
                out.flush();
                helper.resumeService(this.f_sServiceName);
                out.println("Service resumed");
                out.flush();
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in RESUME SERVICE");
            }
            return new DefaultStatementResult("Success", true);
        }

        @Override
        public void showPlan(PrintWriter out) {
        }
    }
}

