/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.token.persistence;

import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.token.SQLOPToken;
import com.tangosol.coherence.dsltools.precedence.OPException;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;

public class SQLRetrieveSnapshotOPToken
extends SQLOPToken {
    public static final String FUNCTOR = "sqlRetrieveSnapshot";

    public SQLRetrieveSnapshotOPToken(String id) {
        super(id, IDENTIFIER_NODE);
    }

    @Override
    public Term nud(OPParser p) {
        OPScanner s = p.getScanner();
        String sCommand = "RETRIEVE ARCHIVED SNAPSHOT";
        if (s.isEndOfStatement()) {
            throw new OPException("Please include ARCHIVED keyword for RETRIEVE ARCHIVED SNAPSHOT");
        }
        if (s.advanceWhenMatching("archived")) {
            if (s.advanceWhenMatching("snapshot")) {
                Term termSnapshotName = PersistenceToolsHelper.getNextTerm(s, "snapshotname", "Snapshot Name", "RETRIEVE ARCHIVED SNAPSHOT");
                Term termServiceName = PersistenceToolsHelper.getNextTerm(s, "service", "Service Name", "RETRIEVE ARCHIVED SNAPSHOT");
                Term termOverwrite = Terms.newTerm("overwrite", AtomicTerm.createString(s.advanceWhenMatching("overwrite") ? "true" : "false"));
                return Terms.newTerm(FUNCTOR, termSnapshotName, termServiceName, termOverwrite);
            }
            throw new OPException("Expected SNAPSHOT but found " + s.getCurrentAsString());
        }
        return super.nud(p);
    }
}

