/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.DataSource;
import com.tangosol.coherence.reporter.FilterFactory;
import com.tangosol.coherence.reporter.MBeanQuery;
import com.tangosol.coherence.reporter.QueryHandler;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.coherence.reporter.locator.ColumnLocator;
import com.tangosol.coherence.reporter.locator.CorrelatedLocator;
import com.tangosol.coherence.reporter.locator.NodeLocator;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMXQueryHandler
implements QueryHandler,
Constants {
    protected long m_lBatch;
    protected long m_ldtStartTime;
    protected List m_listColumns = new LinkedList();
    protected List m_listQueryCol;
    protected Map m_mapColumns = new HashMap();
    protected List m_listXmlCol;
    protected String m_sQueryTemp;
    protected XmlElement m_xml;
    protected XmlElement m_xmlFilter;
    protected XmlElement m_xmlColumns;
    protected MBeanQuery m_mbeanQuery;
    protected DataSource m_source;
    protected Set m_setKeys;
    protected Object m_oCorrelated;
    protected boolean m_fGroupBy;
    protected Boolean m_FMultiTenant;
    public static Map m_mapMacroExtractors = new HashMap();
    public static Map m_mapColumnClass = new HashMap();

    @Override
    public void setContext(XmlElement xmlQuery, XmlElement xmlReportCfg) {
        DataSource source = this.m_source;
        if (source == null) {
            source = this.m_source = new DataSource();
        }
        if (this.m_xml == null) {
            this.m_xml = xmlReportCfg;
            this.m_xmlColumns = xmlReportCfg.getElement("row");
            this.m_listXmlCol = this.m_xmlColumns.getElementList();
            this.m_sQueryTemp = xmlQuery.getSafeElement("pattern").getString();
            this.m_xmlFilter = xmlQuery.getSafeElement("filter-ref");
            boolean fMultiTenant = this.isMultiTenant();
            this.m_listQueryCol = xmlQuery.getSafeElement("params").getElementList();
            ArrayList<SimpleElement> listQueryCol = this.m_listQueryCol;
            boolean fQueryEmpty = false;
            if (listQueryCol.size() == 0) {
                fQueryEmpty = true;
                listQueryCol = this.m_listQueryCol = new ArrayList<SimpleElement>();
            }
            List listXmlCol = this.m_listXmlCol;
            boolean fGroupBy = this.m_fGroupBy;
            Iterator iterCol = listXmlCol.iterator();
            while (iterCol.hasNext()) {
                XmlElement xmlColumn = Reporter.replaceHidden((XmlElement)iterCol.next(), !fMultiTenant);
                boolean fHidden = xmlColumn.getSafeElement("hidden").getBoolean(false);
                boolean fSubQuery = xmlColumn.getSafeElement("subquery").getBoolean(false);
                if (fQueryEmpty && !fSubQuery) {
                    String sColumnRef = xmlColumn.getSafeAttribute("id").getString();
                    SimpleElement xmlTemp = new SimpleElement("column-ref", sColumnRef);
                    listQueryCol.add(xmlTemp);
                }
                fGroupBy |= !fHidden && xmlColumn.getSafeElement("group-by").getBoolean(false);
            }
            this.m_fGroupBy = fGroupBy;
        }
    }

    @Override
    public XmlElement getContext() {
        return this.m_xml;
    }

    public void setPattern(String sPattern) {
        this.m_sQueryTemp = sPattern;
    }

    @Override
    public void postProcess() {
        List listColumn = this.m_listColumns;
        Set setKeys = this.m_setKeys;
        for (ColumnLocator columnLocator : listColumn) {
            if (columnLocator == null) continue;
            columnLocator.reset(setKeys);
        }
        this.m_source.postProcess();
    }

    @Override
    public void execute() {
        this.m_ldtStartTime = System.currentTimeMillis();
        DataSource source = this.m_source;
        source.setGroupBy(this.m_fGroupBy);
        this.initColumns();
        MBeanQuery query = this.ensureBeanQuery();
        Set setKeys = this.getKeys();
        source.execute(query, setKeys);
    }

    @Override
    public Set getKeys() {
        Set setKeys;
        MBeanQuery mapBeans = this.ensureBeanQuery();
        XmlElement xmlFilters = this.m_xml.getElement("filters");
        if (xmlFilters == null) {
            setKeys = mapBeans.keySet();
        } else {
            Filter filter;
            FilterFactory filterFactory = new FilterFactory(this, xmlFilters);
            String sId = this.m_xmlFilter.getString("");
            setKeys = sId.length() == 0 ? mapBeans.keySet() : ((filter = filterFactory.getFilter(sId)) == null ? mapBeans.keySet() : mapBeans.keySet(filter));
        }
        this.m_setKeys = setKeys;
        return setKeys;
    }

    @Override
    public Set getGroupKeys() {
        return this.m_source.getGroupKeys();
    }

    @Override
    public Object getValue(Object key, Object oSourceId) {
        Map mapSources = this.m_mapColumns;
        ColumnLocator qc = (ColumnLocator)mapSources.get(oSourceId);
        return qc == null ? null : qc.getValue(key);
    }

    @Override
    public boolean isAggregate(Object column) {
        Map mapColumns = this.m_mapColumns;
        ColumnLocator qc = (ColumnLocator)mapColumns.get(column);
        return qc != null && qc.isAggregate();
    }

    @Override
    public boolean isDetail(Object column) {
        Map mapColumns = this.m_mapColumns;
        ColumnLocator qc = (ColumnLocator)mapColumns.get(column);
        return qc != null && qc.isRowDetail();
    }

    @Override
    public boolean isMultiTenant() {
        Boolean FMultiTenant = this.m_FMultiTenant;
        if (FMultiTenant == null) {
            String sPattern = this.replaceMacros(this.m_sQueryTemp, null);
            try {
                Optional<ObjectName> optName = this.getMBeanServer().queryNames(new ObjectName(sPattern), null).stream().filter(name -> name.getKeyProperty("domainPartition") != null).findAny();
                FMultiTenant = this.m_FMultiTenant = Boolean.valueOf(optName.isPresent());
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
        return FMultiTenant;
    }

    protected void initColumns() {
        Map mapColumns = this.m_mapColumns;
        List listColumn = this.m_listColumns;
        if (mapColumns.isEmpty()) {
            for (XmlElement xmlRef : this.m_listQueryCol) {
                String sColRef;
                ColumnLocator locator = this.ensureColumnLocator(xmlRef, sColRef = xmlRef.getString());
                if (locator == null) continue;
                listColumn.add(locator);
                mapColumns.put(locator.getId(), locator);
                if (!(locator instanceof CorrelatedLocator)) continue;
                ((CorrelatedLocator)locator).setCorrellatedObject(this.m_oCorrelated);
            }
        } else {
            for (ColumnLocator cl : listColumn) {
                cl.configure(cl.getConfig());
                cl.setDataSource(this.m_source);
                if (!(cl instanceof CorrelatedLocator)) continue;
                ((CorrelatedLocator)cl).setCorrellatedObject(this.m_oCorrelated);
            }
        }
    }

    public ColumnLocator ensureColumnLocator(XmlElement xmlColumn) {
        ColumnLocator columnLocator;
        if (xmlColumn == null) {
            return null;
        }
        XmlValue xmlId = xmlColumn.getAttribute("id");
        Map mapColumns = this.ensureSourceMap();
        XmlElement xmlColDef = xmlColumn;
        if (xmlId != null) {
            String sId = xmlId.getString();
            xmlColDef = this.getColumnCfg(xmlColumn, sId);
        }
        if ((columnLocator = (ColumnLocator)mapColumns.get(JMXQueryHandler.getColumnKey(xmlColumn))) == null) {
            try {
                columnLocator = JMXQueryHandler.newColumnLocator(xmlColDef);
                columnLocator.configure(xmlColDef, this, this.m_source);
                mapColumns.put(JMXQueryHandler.getColumnKey(xmlColDef), columnLocator);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (Exception e) {
                Base.log(e);
                return null;
            }
        }
        return columnLocator;
    }

    public Map ensureSourceMap() {
        HashMap mapColumns = this.m_mapColumns;
        if (mapColumns == null) {
            this.m_mapColumns = mapColumns = new HashMap();
        }
        return mapColumns;
    }

    public static ColumnLocator newColumnLocator(XmlElement xmlColumn) {
        String sClass;
        String sTypeValue = xmlColumn.getSafeElement("type").getString("attribute");
        if (sTypeValue.equals("custom")) {
            sClass = xmlColumn.getSafeElement("column-class").getString();
        } else {
            int nType = JMXQueryHandler.columnFromString(sTypeValue);
            switch (nType) {
                case 4: {
                    sTypeValue = sTypeValue + "," + xmlColumn.getSafeElement("name").getString();
                    break;
                }
                case 1: {
                    sTypeValue = sTypeValue + "," + xmlColumn.getSafeElement("function-name").getString();
                }
            }
            sClass = (String)m_mapColumnClass.get(sTypeValue);
        }
        if (sClass == null || sClass.length() == 0) {
            sClass = sTypeValue;
        }
        try {
            return (ColumnLocator)ClassHelper.newInstance(Class.forName(sClass), null);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to instantiate ColumnLocator " + sClass);
        }
    }

    protected List ensureColumnList() {
        LinkedList listColumns = this.m_listColumns;
        if (listColumns == null) {
            this.m_listColumns = listColumns = new LinkedList();
        }
        return listColumns;
    }

    protected XmlElement getColumnCfg(XmlElement xmlColumn, String sId) {
        List listXml = this.m_listXmlCol;
        for (XmlElement xmlSub : listXml) {
            String sTemp = xmlSub.getSafeAttribute("id").getString();
            if (!sTemp.equals(sId)) continue;
            return xmlSub;
        }
        Base.log("Unable to locate column-ref \"" + sId + "\"");
        return null;
    }

    protected static Object getColumnKey(XmlElement xmlColumn) {
        XmlValue xmlTemp = xmlColumn.getAttribute("id");
        if (xmlTemp == null) {
            return xmlColumn;
        }
        return xmlTemp.getString();
    }

    @Override
    public String replaceMacros(String sTemplate, Object oSource) {
        String sRet = sTemplate;
        Set setMacros = Reporter.getMacros(sTemplate);
        Map mapMacroExtractors = m_mapMacroExtractors;
        for (String sId : setMacros) {
            Object oValue;
            ColumnLocator nl = (ColumnLocator)mapMacroExtractors.get(sId);
            ValueExtractor ve = nl == null ? this.ensureExtractor(sId) : nl.getExtractor();
            if (ve == null || (oValue = ve.extract(oSource)) == null) continue;
            sRet = sRet.replaceAll("\\{" + sId + "\\}", oValue.toString());
        }
        return sRet;
    }

    public ColumnLocator ensureColumnLocator(XmlElement xmlColRef, String sId) {
        return this.ensureColumnLocator(this.getColumnCfg(xmlColRef, sId));
    }

    protected MBeanQuery ensureBeanQuery() {
        MBeanQuery query = this.m_mbeanQuery;
        if (query == null) {
            String sTemplate = this.m_sQueryTemp;
            String sQuery = this.replaceMacros(sTemplate, null);
            this.m_mbeanQuery = query = new MBeanQuery(sQuery, this.getMBeanServer());
        }
        return query;
    }

    public ValueExtractor ensureExtractor(XmlElement xmlColumn) {
        String sId = xmlColumn.getAttribute("id").getString();
        this.ensureColumnLocator(xmlColumn);
        return this.ensureExtractor(sId);
    }

    public ValueExtractor ensureExtractor(String sExtractorId) {
        ColumnLocator qc = this.ensureColumnLocator(null, sExtractorId);
        return qc == null ? null : qc.getExtractor();
    }

    @Override
    public void setCorrelated(Object oTarget) {
        this.m_oCorrelated = oTarget;
    }

    public long getBatch() {
        return this.m_lBatch;
    }

    protected void setBatch(long lBatch) {
        this.m_lBatch = lBatch;
    }

    public long getStartTime() {
        return this.m_ldtStartTime;
    }

    protected static int columnFromString(String sType) {
        if (sType.equals("global")) {
            return 4;
        }
        if (sType.equals("function")) {
            return 1;
        }
        if (sType.equals("method")) {
            return 2;
        }
        if (sType.equals("key")) {
            return 3;
        }
        if (sType.equals("")) {
            return 0;
        }
        if (sType.equals("attribute")) {
            return 0;
        }
        return -1;
    }

    protected MBeanServer getMBeanServer() {
        return this.m_source == null ? null : this.m_source.getMBeanServer();
    }

    static {
        String sBase = "com.tangosol.coherence.reporter.locator.";
        m_mapMacroExtractors.put("node", new NodeLocator());
        m_mapColumnClass.put("attribute", sBase + "AttributeLocator");
        m_mapColumnClass.put("method", sBase + "OperationLocator");
        m_mapColumnClass.put("subquery", sBase + "SubQueryLocator");
        m_mapColumnClass.put("constant", sBase + "ConstantLocator");
        m_mapColumnClass.put("correlated", sBase + "CorrelatedLocator");
        m_mapColumnClass.put("property", sBase + "PropertyLocator");
        m_mapColumnClass.put("global,{batch-counter}", sBase + "BatchLocator");
        m_mapColumnClass.put("global,\\{node\\}", sBase + "NodeLocator");
        m_mapColumnClass.put("global,{report-time}", sBase + "DateTimeLocator");
        m_mapColumnClass.put("key", sBase + "KeyLocator");
        m_mapColumnClass.put("function,sum", sBase + "SumLocator");
        m_mapColumnClass.put("function,count", sBase + "CountLocator");
        m_mapColumnClass.put("function,avg", sBase + "AverageLocator");
        m_mapColumnClass.put("function,min", sBase + "MinLocator");
        m_mapColumnClass.put("function,max", sBase + "MaxLocator");
        m_mapColumnClass.put("function,delta", sBase + "DeltaLocator");
        m_mapColumnClass.put("function,divide", sBase + "DivideLocator");
        m_mapColumnClass.put("function,add", sBase + "AddLocator");
        m_mapColumnClass.put("function,subtract", sBase + "SubtractLocator");
        m_mapColumnClass.put("function,multiply", sBase + "MultiplyLocator");
    }
}

