/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.coherence.reporter.ReportControl;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.TaskDaemon;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ReportBatch
extends Base
implements Runnable,
ReportControl {
    private AtomicReference<String> m_refState = new AtomicReference<String>("Stopped");
    private String m_sLastReport;
    private String m_sOutputDir;
    private String m_sConfigFile;
    private long m_nCurrentBatch;
    private boolean m_fRun;
    private String[] m_asReports;
    private long m_nInterval;
    private XmlDocument m_xml;
    protected TaskDaemon m_daemon;
    private long m_ldtLastExecutionMillis;
    private XmlElement[] m_aParams;
    protected Map m_mapReporters = new HashMap();
    protected long m_lastRuntimeMillis;
    protected long m_maxRuntimeMillis;
    protected long m_cExecutionCount;
    protected long m_totalRuntimeMillis;
    private Dependencies m_dependencies;
    protected DateFormat m_dateFormat;
    protected Map<String, TabularReportRunner> f_mapReporter = new HashMap<String, TabularReportRunner>();
    public static final String STATE_STARTED = "Started";
    public static final String STATE_STOPPING = "Stopping";
    public static final String STATE_STOPPED = "Stopped";
    public static final String STATE_WAITING = "Sleeping";
    public static final String STATE_RUNNING = "Running";
    public static final String STATE_ERROR = "Error";
    public static final String TAG_FREQ = "frequency";
    public static final String TAG_LOCATION = "location";
    public static final String TAG_PARAMS = "init-params";
    public static final String TAG_DIR = "output-directory";
    public static final String TAG_LIST = "report-list";
    public static final String DEFAULT_FREQ = "60s";
    public static final String DEFAULT_TABULAR_TYPE_NAME = "coherence-report.xml";

    public static void main(String[] asArg) {
        if (asArg.length == 0) {
            ReportBatch.showUsage();
            return;
        }
        String sFile = asArg[0];
        System.setProperty("coherence.management.report.configuration", sFile);
        System.setProperty("coherence.management.report.autostart", "true");
        System.setProperty("coherence.management.report.distributed", "false");
        while (true) {
            CacheFactory.ensureCluster();
            try {
                Blocking.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
        }
    }

    @Override
    public void run() {
        long ldtStart = System.currentTimeMillis();
        ReportBatch model = this;
        Map map = this.m_mapReporters;
        model.setCurrentBatch(model.getCurrentBatch() + 1L);
        long nBatchId = model.getCurrentBatch();
        String[] aReport = model.getReports();
        XmlElement[] aParam = model.getParams();
        String sPath = this.m_sOutputDir;
        long cReports = aReport.length;
        if (model.setState(STATE_WAITING, STATE_RUNNING) || model.setState(STATE_STARTED, STATE_RUNNING)) {
            model.setLastExecutionMillis(System.currentTimeMillis());
            int i = 0;
            while ((long)i < cReports) {
                Integer nKey = i;
                String sDefFile = aReport[i];
                XmlElement xmlParam = aParam[i];
                Reporter reporter = (Reporter)map.get(nKey);
                if (reporter == null) {
                    reporter = new Reporter();
                    map.put(nKey, reporter);
                }
                reporter.setDateFormat(this.m_dateFormat);
                model.setLastReport(sDefFile);
                reporter.run(sDefFile, sPath, nBatchId, xmlParam, ReportBatch.class.getClassLoader());
                ++i;
            }
            this.updateStats(ldtStart);
            model.setState(STATE_RUNNING, STATE_WAITING);
        }
    }

    public static void showUsage() {
        ReportBatch.out();
        ReportBatch.out("java com.tangosol.coherence.reporter.ReportBatch <config-file>");
        ReportBatch.out();
        ReportBatch.out("command option descriptions:");
        ReportBatch.out("\t<config-file> the file containing the report configuration XML");
        ReportBatch.out();
    }

    @Override
    public TaskDaemon getDaemon() {
        return this.m_daemon;
    }

    @Override
    public void setDaemon(TaskDaemon daemon) {
        this.m_daemon = daemon;
    }

    @Override
    public boolean isRunning() {
        return this.m_fRun;
    }

    @Override
    public void setLastReport(String sLastReport) {
        this.m_sLastReport = sLastReport;
    }

    @Override
    public void setReports(String[] asReports) {
        this.m_asReports = asReports;
    }

    @Override
    public void setLastExecutionMillis(long ldtTime) {
        this.m_ldtLastExecutionMillis = ldtTime;
    }

    @Override
    public long getLastExecutionMillis() {
        return this.m_ldtLastExecutionMillis;
    }

    @Override
    public void setState(String sState) {
        this.m_refState.set(sState);
    }

    public boolean setState(String sExpectState, String sNewState) {
        return this.m_refState.compareAndSet(sExpectState, sNewState);
    }

    @Override
    public XmlDocument getXml() {
        return this.m_xml;
    }

    @Override
    public void setXml(XmlDocument xml) {
        this.m_xml = xml;
    }

    private String[] makeReportArray(XmlElement xmlReports) {
        List listReports = xmlReports.getElementList();
        String[] asReports = new String[listReports.size()];
        XmlElement[] axmlParam = new XmlElement[listReports.size()];
        int c = 0;
        for (XmlElement o : listReports) {
            asReports[c] = o.getSafeElement(TAG_LOCATION).getString();
            axmlParam[c] = o.getElement(TAG_PARAMS);
            ++c;
        }
        this.m_aParams = axmlParam;
        return asReports;
    }

    @Override
    public long getCurrentBatch() {
        return this.m_nCurrentBatch;
    }

    @Override
    public void setCurrentBatch(long nNewBatch) {
        this.m_nCurrentBatch = nNewBatch;
    }

    @Override
    public long getIntervalSeconds() {
        return this.m_nInterval / 1000L;
    }

    @Override
    public String getOutputPath() {
        return this.m_sOutputDir == null ? "" : new File(this.m_sOutputDir).getAbsolutePath();
    }

    @Override
    public void setOutputPath(String sPath) {
        this.m_sOutputDir = sPath;
    }

    @Override
    public void setIntervalSeconds(long nInterval) {
        this.m_nInterval = nInterval * 1000L;
    }

    @Override
    public String getConfigFile() {
        return this.m_sConfigFile;
    }

    @Override
    public String getState() {
        return this.m_refState.get();
    }

    @Override
    public boolean isAutoStart() {
        return this.getDependencies().isAutoStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.getState().equals(STATE_ERROR)) {
            ReportBatch reportBatch = this;
            synchronized (reportBatch) {
                if (this.isRunning()) {
                    this.m_fRun = false;
                    this.setState(STATE_STOPPING);
                    this.getDaemon().stop();
                    this.setState(STATE_STOPPED);
                    this.setDaemon(null);
                    Base.log("Management Reporting - Stopped");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.getState().equals(STATE_ERROR)) {
            Base.log("Management Reporting - An unrecoverable error has occurred. Reporter not started.");
        } else {
            ReportBatch reportBatch = this;
            synchronized (reportBatch) {
                TaskDaemon daemon = this.getDaemon();
                if (this.m_daemon == null && this.m_sConfigFile != null) {
                    ReportBatch oReport = this;
                    daemon = new TaskDaemon("Reporter");
                    daemon.schedulePeriodicTask(oReport, System.currentTimeMillis() + this.getIntervalSeconds() * 1000L, this.getIntervalSeconds() * 1000L);
                    Base.log("Management Reporting -  Started");
                    daemon.start();
                    this.setState(STATE_STARTED);
                    this.m_fRun = true;
                }
                this.setDaemon(daemon);
            }
        }
    }

    @Override
    public String[] getReports() {
        return this.m_asReports;
    }

    @Override
    public XmlElement[] getParams() {
        return this.m_aParams;
    }

    @Override
    public void setParams(XmlElement[] aXml) {
        this.m_aParams = aXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigFile(String sInputFilename) {
        try {
            ReportBatch reportBatch = this;
            synchronized (reportBatch) {
                this.m_mapReporters = new HashMap();
                this.m_sConfigFile = sInputFilename;
                XmlDocument xml = XmlHelper.loadFileOrResource(sInputFilename, "Reporter configuration", ReportBatch.class.getClassLoader());
                XmlHelper.replaceSystemProperties(xml, "system-property");
                this.setXml(xml);
                this.setOutputPath(xml.getSafeElement(TAG_DIR).getString(""));
                this.setIntervalSeconds(Base.parseTime(xml.getSafeElement(TAG_FREQ).getString(DEFAULT_FREQ)) / 1000L);
                this.m_asReports = this.makeReportArray(xml.getSafeElement(TAG_LIST));
            }
        }
        catch (Exception e) {
            this.setState(STATE_ERROR);
            Base.log("Failed to start Reporter " + e);
            this.m_asReports = new String[0];
        }
    }

    @Override
    public void runReport(String sReportFile) {
        if (!this.getState().equals(STATE_ERROR)) {
            new Reporter().run(sReportFile, this.m_sOutputDir, this.m_nCurrentBatch, null, ReportBatch.class.getClassLoader());
        }
    }

    @Override
    public TabularData runTabularReport(String sReportFile) {
        TabularReportRunner runner;
        boolean fURI = Reporter.isURI(sReportFile);
        TabularReportRunner tabularReportRunner = runner = fURI ? this.f_mapReporter.get(sReportFile) : new TabularReportRunner(sReportFile, fURI);
        if (runner == null) {
            runner = new TabularReportRunner(sReportFile, fURI);
            this.f_mapReporter.put(sReportFile, runner);
        }
        return runner.runTabularReport();
    }

    @Override
    public TabularData runTabularGroupReport(String sReportName, Map<String, String> mapXmlReports) {
        TabularReportRunner runner = new TabularReportRunner(sReportName, mapXmlReports);
        return runner.runTabularReport();
    }

    @Override
    public String getLastReport() {
        return this.m_sLastReport;
    }

    @Override
    public Date getLastExecuteTime() {
        return new Date(this.getLastExecutionMillis());
    }

    @Override
    public long getRunLastMillis() {
        return this.m_lastRuntimeMillis;
    }

    @Override
    public long getRunMaxMillis() {
        return this.m_maxRuntimeMillis;
    }

    @Override
    public double getRunAverageMillis() {
        return this.m_cExecutionCount == 0L ? 0.0 : (double)(this.m_totalRuntimeMillis / this.m_cExecutionCount);
    }

    @Override
    public void resetStatistics() {
        this.m_lastRuntimeMillis = 0L;
        this.m_maxRuntimeMillis = 0L;
        this.m_cExecutionCount = 0L;
        this.m_totalRuntimeMillis = 0L;
    }

    @Override
    public boolean isCentralized() {
        return this.getDependencies().isDistributed();
    }

    protected void updateStats(long ldtStart) {
        long lRuntime = System.currentTimeMillis() - ldtStart;
        ++this.m_cExecutionCount;
        this.m_maxRuntimeMillis = this.m_maxRuntimeMillis < lRuntime ? lRuntime : this.m_maxRuntimeMillis;
        this.m_totalRuntimeMillis += lRuntime;
        this.m_lastRuntimeMillis = lRuntime;
    }

    @Override
    public void setDependencies(Dependencies dps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Reporter dependencies cannot be reset");
        }
        this.m_dependencies = dps = new DefaultDependencies(dps).validate();
        this.setConfigFile(dps.getConfigFile());
        String sTimezone = dps.getTimeZone();
        String sTimeStampFormat = dps.getDateFormat();
        this.m_dateFormat = new SimpleDateFormat(sTimeStampFormat);
        if (!sTimezone.isEmpty()) {
            this.m_dateFormat.setTimeZone(ReportBatch.getTimeZone(sTimezone));
        }
    }

    @Override
    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    public class TabularReportRunner {
        protected final String f_sReport;
        protected final String f_sReportGroup;
        protected final boolean f_fURI;
        protected final boolean f_fReportGrp;
        protected Map<String, String> f_mapReports;
        protected final Map<String, Reporter> f_mapReporter = new HashMap<String, Reporter>();

        public TabularReportRunner(String sReportOrGroup, boolean fURI) {
            this.f_fURI = fURI;
            XmlDocument xmlDocument = fURI ? XmlHelper.loadFileOrResource(sReportOrGroup, "Reporter configuration", ReportBatch.class.getClassLoader()) : XmlHelper.loadXml(sReportOrGroup);
            this.f_fReportGrp = xmlDocument.getName().equals("report-group");
            if (this.f_fReportGrp) {
                this.f_sReportGroup = sReportOrGroup;
                this.f_sReport = null;
                List xmlReports = xmlDocument.getSafeElement(ReportBatch.TAG_LIST).getElementList();
                this.f_mapReports = new LinkedHashMap<String, String>(xmlReports.size());
                Iterator iter = xmlReports.iterator();
                while (iter.hasNext()) {
                    this.f_mapReports.put(((XmlElement)iter.next()).getSafeElement(ReportBatch.TAG_LOCATION).getString(), null);
                }
            } else {
                this.f_sReport = sReportOrGroup;
                this.f_sReportGroup = null;
            }
        }

        public TabularReportRunner(String sReportGroup, Map<String, String> mapXmlReports) {
            this.f_sReportGroup = sReportGroup;
            this.f_fURI = false;
            this.f_fReportGrp = true;
            this.f_sReport = null;
            this.f_mapReports = new LinkedHashMap<String, String>(mapXmlReports);
        }

        public TabularData runTabularReport() {
            if (!ReportBatch.this.getState().equals(ReportBatch.STATE_ERROR)) {
                if (this.f_fReportGrp) {
                    int cReports = this.f_mapReports.size();
                    OpenType[] aOpenTypes = new OpenType[cReports];
                    String[] asReportDesc = new String[cReports];
                    String[] asReportNames = new String[cReports];
                    HashMap<String, TabularData> mapTabulars = new HashMap<String, TabularData>();
                    int i = 0;
                    for (Map.Entry<String, String> entry : this.f_mapReports.entrySet()) {
                        String sReport = entry.getKey();
                        String sContent = entry.getValue();
                        int index = sReport.lastIndexOf(47);
                        String sTabularType = index < 0 ? sReport : sReport.substring(index);
                        TabularData tabData = this.runSingleReport(sContent == null ? sReport : sContent, sTabularType);
                        asReportNames[i] = sReport;
                        mapTabulars.put(sReport, tabData);
                        if (tabData == null) {
                            aOpenTypes[i] = SimpleType.STRING;
                            asReportDesc[i] = sTabularType;
                        } else {
                            TabularType tabType = tabData.getTabularType();
                            aOpenTypes[i] = tabType;
                            asReportDesc[i] = tabType.getDescription();
                        }
                        ++i;
                    }
                    try {
                        String sReport = this.f_sReportGroup;
                        CompositeType rowType = new CompositeType(sReport, sReport, asReportNames, asReportDesc, aOpenTypes);
                        TabularType tabType = new TabularType(sReport, sReport, rowType, asReportNames);
                        TabularDataSupport tabDataSupport = new TabularDataSupport(tabType);
                        tabDataSupport.put(new CompositeDataSupport(rowType, mapTabulars));
                        return tabDataSupport;
                    }
                    catch (OpenDataException e) {
                        throw Base.ensureRuntimeException(e);
                    }
                }
                return this.runSingleReport(this.f_sReport, this.f_fURI ? this.f_sReport : ReportBatch.DEFAULT_TABULAR_TYPE_NAME);
            }
            return null;
        }

        protected TabularData runSingleReport(String sReport, String sTabularType) {
            Reporter reporter = this.getReporter(sReport);
            return reporter.run(sReport, ReportBatch.this.m_sOutputDir, sTabularType, ReportBatch.this.m_nCurrentBatch, null, ReportBatch.class.getClassLoader(), false, true);
        }

        protected Reporter getReporter(String sReportFile) {
            Reporter reporter;
            Reporter reporter2 = reporter = this.f_fURI ? this.f_mapReporter.get(sReportFile) : new Reporter();
            if (reporter == null) {
                reporter = new Reporter();
                this.f_mapReporter.put(sReportFile, reporter);
            }
            return reporter;
        }
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected String m_sConfigFile = "reports/report-group.xml";
        protected boolean m_autoStart = false;
        protected boolean m_distributed = false;
        protected String m_sTimezone = "";
        protected String m_sDateFormat = "EEE MMM dd HH:mm:ss zzz yyyy";

        public DefaultDependencies() {
            this(null);
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_sConfigFile = deps.getConfigFile();
                this.m_autoStart = deps.isAutoStart();
                this.m_distributed = deps.isDistributed();
                this.m_sTimezone = deps.getTimeZone();
                this.m_sDateFormat = deps.getDateFormat();
            }
        }

        @Override
        public String getConfigFile() {
            return this.m_sConfigFile;
        }

        public DefaultDependencies setConfigFile(String sConfFile) {
            this.m_sConfigFile = sConfFile;
            return this;
        }

        @Override
        public boolean isAutoStart() {
            return this.m_autoStart;
        }

        public DefaultDependencies setAutoStart(boolean fAutoStart) {
            this.m_autoStart = fAutoStart;
            return this;
        }

        @Override
        public boolean isDistributed() {
            return this.m_distributed;
        }

        public DefaultDependencies setDistributed(boolean fDistributed) {
            this.m_distributed = fDistributed;
            return this;
        }

        @Override
        public String getTimeZone() {
            return this.m_sTimezone;
        }

        public DefaultDependencies setTimeZone(String sTimeZone) {
            this.m_sTimezone = sTimeZone;
            return this;
        }

        @Override
        public String getDateFormat() {
            return this.m_sDateFormat;
        }

        public DefaultDependencies setDateFormat(String sTimeFormat) {
            this.m_sDateFormat = sTimeFormat;
            return this;
        }

        public DefaultDependencies validate() {
            Base.checkNotNull(this.m_sConfigFile, "configuration");
            return this;
        }
    }

    public static interface Dependencies {
        public String getConfigFile();

        public boolean isAutoStart();

        public boolean isDistributed();

        public String getTimeZone();

        public String getDateFormat();
    }
}

