/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.JMXQueryHandler;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;

public class SubQueryExtractor
implements ValueExtractor,
Constants {
    protected XmlElement m_xmlQuery;
    protected String m_sPatternTemplate;
    protected JMXQueryHandler m_jmxqOuter;
    protected String m_sColumnId;
    protected MultiExtractor m_ME;

    public SubQueryExtractor(ValueExtractor[] aExtractor, XmlElement xmlQuery, JMXQueryHandler jmxqOuter, String sColumnId) {
        if (aExtractor.length > 0) {
            this.m_ME = new MultiExtractor(aExtractor);
        }
        this.m_sPatternTemplate = xmlQuery.getElement("pattern").getString();
        this.m_xmlQuery = xmlQuery;
        this.m_jmxqOuter = jmxqOuter;
        this.m_sColumnId = sColumnId;
    }

    public Object extract(Object oTarget) {
        ImmutableArrayList arResults = this.m_ME != null ? (ImmutableArrayList)this.m_ME.extract(oTarget) : null;
        Set setMacros = Reporter.getMacros(this.m_sPatternTemplate);
        String sPattern = this.m_sPatternTemplate;
        int c = 0;
        if (arResults != null) {
            for (String sId : setMacros) {
                Object oValue = arResults.get(c);
                if (oValue != null) {
                    sPattern = sPattern.replaceAll("\\{" + sId + "\\}", oValue.toString());
                }
                ++c;
            }
        }
        this.m_xmlQuery.getElement("pattern").setString(sPattern);
        JMXQueryHandler inner = new JMXQueryHandler();
        inner.setCorrelated(oTarget);
        inner.setContext(this.m_xmlQuery, this.m_jmxqOuter.getContext());
        inner.execute();
        return inner.getValue(null, this.m_sColumnId);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException(SubQueryExtractor.class.getCanonicalName() + " is not serializable");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(SubQueryExtractor.class.getCanonicalName() + " is not serializable");
    }
}

