/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.locator;

import com.tangosol.coherence.reporter.DataSource;
import com.tangosol.coherence.reporter.locator.BaseLocator;
import com.tangosol.coherence.reporter.locator.ColumnLocator;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FunctionLocator
extends BaseLocator {
    protected ValueExtractor m_veColumn1;
    protected ValueExtractor m_veColumn2;
    protected String m_sId1;
    protected String m_sId2;
    protected boolean m_fAggregate;
    protected boolean m_fDetail;

    @Override
    public void configure(XmlElement xmlConfig) {
        super.configure(xmlConfig);
        XmlElement xmlColumns = xmlConfig.getElement("params");
        List listColumns = xmlColumns.getElementList();
        Iterator iter = listColumns.iterator();
        String sId = ((XmlElement)iter.next()).getString();
        ColumnLocator qc = this.m_queryHandler.ensureColumnLocator(null, sId);
        this.m_veColumn1 = Base.checkNotNull(this.m_queryHandler.ensureExtractor(sId), "Column extractor");
        boolean fAgg1 = qc.isAggregate();
        boolean fDet1 = qc.isRowDetail();
        this.m_sId1 = sId;
        sId = ((XmlElement)iter.next()).getString();
        qc = this.m_queryHandler.ensureColumnLocator(null, sId);
        this.m_veColumn2 = Base.checkNotNull(this.m_queryHandler.ensureExtractor(sId), "Column extractor");
        boolean fAgg2 = qc.isAggregate();
        boolean fDet2 = qc.isRowDetail();
        this.m_sId2 = sId;
        this.m_fAggregate = fAgg1 && fAgg2;
        this.m_fDetail = fDet1 || fDet2;
    }

    @Override
    public void reset(Set setResults) {
        super.reset(setResults);
        this.m_veColumn1 = null;
        this.m_veColumn2 = null;
    }

    @Override
    public Object getValue(Object oKey) {
        if (this.m_fDetail) {
            return this.m_source.getValue(oKey, this.m_iExtractorPos);
        }
        return this.m_source.getScalarValue(oKey, this.m_iExtractorPos);
    }

    @Override
    public void setDataSource(DataSource source) {
        this.m_source = source;
        this.m_iExtractorPos = this.m_fDetail ? this.m_source.addExtractor(this.getExtractor()) : this.m_source.addScalar(this.getExtractor());
    }

    @Override
    public boolean isAggregate() {
        return this.m_fAggregate;
    }

    @Override
    public boolean isRowDetail() {
        return this.m_fDetail;
    }

    protected void buildExtractors() {
        if (this.m_veColumn1 == null) {
            this.m_veColumn1 = this.m_queryHandler.ensureExtractor(this.m_sId1);
        }
        if (this.m_veColumn2 == null) {
            this.m_veColumn2 = this.m_queryHandler.ensureExtractor(this.m_sId2);
        }
    }
}

