/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.expression;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ValueMacroExpression
implements Expression<String>,
ExternalizableLite,
PortableObject {
    public static int MAX_MACRO_EXPANSIONS = 20;
    private String m_sValue;

    public ValueMacroExpression() {
    }

    public ValueMacroExpression(String value) {
        this.m_sValue = value;
    }

    @Override
    public String evaluate(ParameterResolver resolver) {
        String sValue = this.m_sValue;
        if (sValue != null) {
            int ofEnd;
            int nCount = 0;
            int ofStart = sValue.indexOf("${");
            while (ofStart >= 0 && (ofEnd = sValue.indexOf(125, ofStart)) != -1) {
                String sProp;
                String sDefault;
                String sMacro = sValue.substring(ofStart, ofEnd + 1);
                if ((ofStart = sMacro.indexOf(32)) >= 0) {
                    sDefault = sMacro.substring(ofStart, sMacro.length() - 1).trim();
                    sProp = sMacro.substring(2, ofStart);
                } else {
                    sDefault = "";
                    sProp = sMacro.substring(2, sMacro.length() - 1);
                }
                try {
                    String sPropValue;
                    Parameter p = resolver.resolve(sProp);
                    String string = sPropValue = p == null ? sDefault : p.evaluate(resolver).as(String.class);
                    if (sPropValue.contains("${" + sProp) && sPropValue.contains("}") || nCount > MAX_MACRO_EXPANSIONS) {
                        Logger.err("SystemPropertyPreprocessor: using default value of \"" + sDefault + "\", detected recursive macro definition in system property " + sProp + " with the value of \"" + sPropValue + "\" ");
                        sPropValue = sDefault;
                    }
                    sValue = sValue.replace(sMacro, sPropValue);
                }
                catch (Exception e) {
                    sValue = sValue.replace(sMacro, sDefault);
                }
                ofStart = sValue.indexOf("${");
                ++nCount;
            }
        }
        return sValue;
    }

    public static boolean containsMacro(String sValue) {
        if (sValue == null) {
            return false;
        }
        int ofStart = sValue.indexOf("${");
        return ofStart >= 0 && sValue.indexOf(125, ofStart) > 0;
    }

    public boolean containsMacro() {
        return ValueMacroExpression.containsMacro(this.m_sValue);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sValue = (String)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_sValue);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_sValue = (String)reader.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_sValue);
    }

    public String toString() {
        return String.format("ValueMacroExpression[value=%s]", this.m_sValue);
    }
}

