/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.injection;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.injection.Injector;
import com.tangosol.util.ResourceResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class SimpleInjector
implements Injector {
    @Override
    public <T> T inject(T object, ResourceResolver resolver) {
        if (object != null && resolver != null) {
            Class<?> clsObject = object.getClass();
            for (Method method : clsObject.getMethods()) {
                Object oResource;
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || method.getParameterTypes().length != 1) continue;
                Class<?> clsResource = method.getParameterTypes()[0];
                Injectable injectable = method.getAnnotation(Injectable.class);
                if (injectable == null) continue;
                String sResourceName = injectable.value().trim();
                if (sResourceName.isEmpty()) {
                    oResource = resolver.getResource(clsResource);
                } else {
                    try {
                        oResource = resolver.getResource(clsResource, sResourceName);
                    }
                    catch (Exception e) {
                        oResource = null;
                        Logger.warn(String.format("Failed to lookup resource %s resource-type %s for method %s due to %s", sResourceName, clsResource.getCanonicalName(), method, e));
                    }
                }
                if (oResource == null) continue;
                try {
                    method.invoke(object, oResource);
                }
                catch (Exception e) {
                    Logger.warn(String.format("Failed to inject resource %s into %s using method %s due to %s", oResource, object, method, e));
                }
            }
        }
        return object;
    }
}

