/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.SignatureConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InvokeDynamicConstant
extends Constant {
    private int m_nBootstrapIndex;
    private int m_nMethodNameDescIndex;
    private SignatureConstant m_methodNameDesc;

    protected InvokeDynamicConstant() {
        this(0, null);
    }

    public InvokeDynamicConstant(int nBootstrapMethodIndex, SignatureConstant methodNameDesc) {
        super(18);
        this.m_nBootstrapIndex = nBootstrapMethodIndex;
        this.m_methodNameDesc = methodNameDesc;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_nBootstrapIndex = stream.readUnsignedShort();
        this.m_nMethodNameDescIndex = stream.readUnsignedShort();
    }

    @Override
    protected void postdisassemble(ConstantPool pool) {
        this.m_methodNameDesc = (SignatureConstant)pool.getConstant(this.m_nMethodNameDescIndex);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_methodNameDesc);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeShort(this.m_nBootstrapIndex);
        stream.writeShort(pool.findConstant(this.m_methodNameDesc));
    }

    @Override
    public int compareTo(Object obj) {
        return obj instanceof InvokeDynamicConstant ? ((InvokeDynamicConstant)obj).m_nBootstrapIndex - this.m_nBootstrapIndex : 1;
    }

    @Override
    public String toString() {
        return "(InvokeDynamic)->[bootstrap_method_attr_index = " + this.m_nBootstrapIndex + ", method_name_desc = " + this.m_methodNameDesc + "]";
    }

    @Override
    public String format() {
        return this.m_methodNameDesc.format();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InvokeDynamicConstant ? this.m_nBootstrapIndex == ((InvokeDynamicConstant)obj).m_nBootstrapIndex && this.m_methodNameDesc.equals(((InvokeDynamicConstant)obj).m_methodNameDesc) : false;
    }

    public int getBootstrapMethodIndex() {
        return this.m_nBootstrapIndex;
    }

    public void setBootstrapMethodIndex(int nBootstrapMethodIndex) {
        this.m_nBootstrapIndex = nBootstrapMethodIndex;
    }

    public SignatureConstant getMethodNameAndDescription() {
        return this.m_methodNameDesc;
    }

    public void setMethodNameAndDescription(SignatureConstant methodNameAndDescription) {
        this.m_methodNameDesc = methodNameAndDescription;
    }
}

