/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LineNumberTableAttribute
extends Attribute
implements Constants {
    private static final String CLASS = "LineNumberTableAttribute";
    private boolean m_fModified;
    private Entry m_first;
    private Entry m_last;
    private int m_count;

    protected LineNumberTableAttribute(VMStructure context) {
        super(context, "LineNumberTable");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        int count = stream.readUnsignedShort();
        if (count > 0) {
            int i;
            Object[] aln = new Entry[count];
            for (i = 0; i < count; ++i) {
                Entry ln = new Entry();
                ln.disassemble(stream, pool);
                aln[i] = ln;
            }
            Arrays.sort(aln);
            for (i = 1; i < count; ++i) {
                ((Entry)aln[i - 1]).setNext((Entry)aln[i]);
            }
            this.m_first = aln[0];
            this.m_last = aln[count - 1];
            this.m_count = count;
        } else {
            this.m_first = null;
            this.m_last = null;
            this.m_count = 0;
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(2 + 4 * this.m_count);
        stream.writeShort(this.m_count);
        for (Entry ln = this.m_first; ln != null; ln = ln.getNext()) {
            ln.assemble(stream, pool);
        }
    }

    @Override
    public boolean isModified() {
        return this.m_fModified;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }

    public void clear() {
        this.m_first = null;
        this.m_last = null;
        this.m_fModified = true;
    }

    public boolean isEmpty() {
        return this.m_first == null;
    }

    protected void add(int iLine, int of) {
        this.add(new Entry(iLine, of));
    }

    protected void add(Op op) {
        this.add(new Entry(op));
    }

    protected void add(Entry ln) {
        if (this.m_first == null) {
            this.m_first = ln;
            this.m_last = ln;
        } else {
            this.m_last.setNext(ln);
            this.m_last = ln;
        }
        ++this.m_count;
        this.m_fModified = true;
    }

    public Enumeration entries() {
        return new Enumeration(){
            private Entry cur;
            {
                this.cur = LineNumberTableAttribute.this.m_first;
            }

            @Override
            public boolean hasMoreElements() {
                return this.cur != null;
            }

            public Object nextElement() {
                if (this.cur == null) {
                    throw new NoSuchElementException();
                }
                Entry ln = this.cur;
                this.cur = ln.getNext();
                return ln;
            }
        };
    }

    public static class Entry
    extends VMStructure
    implements Constants,
    Comparable {
        private static final String CLASS = "LineNumberTableAttribute.Entry";
        private int m_iLine;
        private Op m_op;
        private int m_of;
        private Entry m_next;

        protected Entry() {
        }

        protected Entry(int iLine, int of) {
            this.m_iLine = iLine;
            this.m_of = of;
        }

        protected Entry(Op op) {
            this.m_iLine = op.getLine();
            this.m_op = op;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_of = stream.readUnsignedShort();
            this.m_iLine = stream.readUnsignedShort();
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeShort(this.getOffset());
            stream.writeShort(this.getLine());
        }

        public int compareTo(Object obj) {
            Entry that = (Entry)obj;
            int nThis = this.m_of;
            int nThat = that.m_of;
            return nThis < nThat ? -1 : (nThis > nThat ? 1 : 0);
        }

        public Op getOp() {
            return this.m_op;
        }

        protected void setOp(Op op) {
            this.m_op = op;
        }

        public int getLine() {
            return this.m_iLine;
        }

        protected int getOffset() {
            return this.m_op == null ? this.m_of : this.m_op.getOffset();
        }

        protected Entry getNext() {
            return this.m_next;
        }

        protected void setNext(Entry next) {
            this.m_next = next;
        }
    }
}

