/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.RefConstant;
import com.tangosol.dev.assembler.SignatureConstant;

public class MethodConstant
extends RefConstant
implements Constants {
    private static final String CLASS = "MethodConstant";
    private String[] m_asType;
    private char[] m_achType;

    protected MethodConstant(int nTag) {
        super(nTag);
    }

    protected MethodConstant(int nTag, String sClass, String sName, String sType) {
        super(nTag, sClass, sName, sType);
    }

    protected MethodConstant(int nTag, ClassConstant constantClz, SignatureConstant constantSig) {
        super(nTag, constantClz, constantSig);
    }

    protected MethodConstant() {
        super(10);
    }

    public MethodConstant(String sClass, String sName, String sType) {
        super(10, sClass, sName, sType);
    }

    public MethodConstant(ClassConstant constantClz, SignatureConstant constantSig) {
        super(10, constantClz, constantSig);
    }

    @Override
    public String toString() {
        return "(Method)->" + super.toString();
    }

    @Override
    public String format() {
        int of;
        String sClass = this.getClassConstant().format();
        if (sClass.startsWith("java") && (of = sClass.lastIndexOf(46)) != -1) {
            sClass = sClass.substring(of + 1);
        }
        sClass = sClass.replace('$', '.');
        SignatureConstant sig = this.getSignatureConstant();
        String sName = sig.getName();
        String sType = sig.getType();
        String[] asType = Method.toTypeStrings(sType);
        int c = asType.length;
        for (int i = 0; i < c; ++i) {
            sType = asType[i];
            int of2 = sType.lastIndexOf(46);
            if (of2 != -1) {
                sType = sType.substring(of2 + 1);
            }
            asType[i] = sType = sType.replace('$', '.');
        }
        StringBuffer sb = new StringBuffer();
        sb.append(asType[0]).append(' ').append(sClass).append('.').append(sName).append('(');
        int c2 = asType.length;
        for (int i = 1; i < c2; ++i) {
            if (i > 1) {
                sb.append(',');
            }
            sb.append(asType[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public String[] getTypes() {
        String[] asType = this.m_asType;
        if (asType == null) {
            asType = Method.toTypes(this.getType());
            this.m_asType = asType;
        }
        return asType;
    }

    public char[] getVariableType() {
        char[] achType = this.m_achType;
        if (achType == null) {
            String[] asType = this.getTypes();
            int cTypes = asType.length;
            achType = new char[cTypes];
            for (int i = 0; i < cTypes; ++i) {
                achType[i] = FieldConstant.getVariableType(asType[i]);
            }
            this.m_achType = achType;
        }
        return achType;
    }

    public char getVariableType(int i) {
        return this.getVariableType()[i];
    }

    public boolean isVoid() {
        return this.getVariableType(0) == '\u0000';
    }

    public int getVariableSize(int i) {
        if (i == 0 && this.isVoid()) {
            return 0;
        }
        return OpDeclare.getWidth(this.getVariableType(i));
    }

    public int getTotalParameterSize() {
        char[] achType = this.getVariableType();
        int cTypes = achType.length;
        int cWords = 0;
        for (int i = 1; i < cTypes; ++i) {
            cWords += OpDeclare.getWidth(achType[i]);
        }
        return cWords;
    }
}

