/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.oracle.coherence.common.collections.ChainedIterator;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class StackMapTableAttribute
extends Attribute
implements Constants {
    private List<StackMapFrame> m_listFrames;

    protected StackMapTableAttribute(VMStructure context) {
        super(context, "StackMapTable");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        int cFrames = stream.readUnsignedShort();
        this.m_listFrames = new LinkedList<StackMapFrame>();
        LinkedList<StackMapFrame> listFrames = this.m_listFrames;
        for (int i = 0; i < cFrames; ++i) {
            listFrames.add(StackMapTableAttribute.loadFrame(this, stream, pool));
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        List<StackMapFrame> listFrames = this.m_listFrames;
        int cLength = 2;
        for (StackMapFrame frame : listFrames) {
            cLength += frame.size();
        }
        stream.writeInt(cLength);
        stream.writeShort(listFrames.size());
        for (StackMapFrame frame : listFrames) {
            frame.assemble(stream, pool);
        }
    }

    public List getFrames() {
        return this.m_listFrames;
    }

    protected static StackMapFrame loadFrame(StackMapTableAttribute context, DataInput stream, ConstantPool pool) throws IOException {
        StackMapFrame frame = null;
        int nTag = stream.readUnsignedByte();
        if ((nTag & 0xC0) == 0) {
            StackMapTableAttribute stackMapTableAttribute = context;
            Objects.requireNonNull(stackMapTableAttribute);
            frame = stackMapTableAttribute.new SameFrame(nTag);
        } else if ((nTag & 0x80) == 0) {
            StackMapTableAttribute stackMapTableAttribute = context;
            Objects.requireNonNull(stackMapTableAttribute);
            frame = stackMapTableAttribute.new SameLocalsOneStackItemFrame(nTag);
        } else {
            switch (nTag) {
                case 247: {
                    frame = context.new SameLocalsOneStackItemFrameExtended();
                    break;
                }
                case 248: 
                case 249: 
                case 250: {
                    StackMapTableAttribute stackMapTableAttribute = context;
                    Objects.requireNonNull(stackMapTableAttribute);
                    frame = stackMapTableAttribute.new ChopFrame(nTag);
                    break;
                }
                case 251: {
                    frame = context.new SameFrameExtended();
                    break;
                }
                case 252: 
                case 253: 
                case 254: {
                    StackMapTableAttribute stackMapTableAttribute = context;
                    Objects.requireNonNull(stackMapTableAttribute);
                    frame = stackMapTableAttribute.new AppendFrame(nTag);
                    break;
                }
                case 255: {
                    frame = context.new FullFrame();
                }
            }
        }
        if (frame != null) {
            frame.disassemble(stream, pool);
        }
        return frame;
    }

    protected static StackMapFrame.VariableInfo loadVariableInfo(StackMapFrame context, DataInput stream, ConstantPool pool) throws IOException {
        byte nTag = stream.readByte();
        StackMapFrame.VariableInfo var = null;
        switch (nTag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                StackMapFrame stackMapFrame = context;
                Objects.requireNonNull(stackMapFrame);
                var = stackMapFrame.new StackMapFrame.VariableInfo(nTag);
                break;
            }
            case 7: {
                var = context.new StackMapFrame.ObjectVariableInfo();
                break;
            }
            case 8: {
                var = context.new StackMapFrame.UninitializedVariableInfo();
            }
        }
        if (var != null) {
            var.disassemble(stream, pool);
        }
        return var;
    }

    public static enum VariableInfoType {
        Top,
        Integer,
        Float,
        Long,
        Double,
        Null,
        UninitializedThis,
        Object,
        Uninitialized;

    }

    public class FullFrame
    extends StackMapFrame {
        private int m_nOffset;
        private List<StackMapFrame.VariableInfo> m_listLocals;
        private List<StackMapFrame.VariableInfo> m_listStack;

        public FullFrame() {
            super(255);
            this.m_listLocals = new LinkedList<StackMapFrame.VariableInfo>();
            this.m_listStack = new LinkedList<StackMapFrame.VariableInfo>();
        }

        @Override
        public int getOffset() {
            return this.m_nOffset;
        }

        public List getLocals() {
            return this.m_listLocals;
        }

        public List getStack() {
            return this.m_listStack;
        }

        public void setOffset(int nOffset) {
            this.m_nOffset = nOffset;
        }

        @Override
        protected int size() {
            int cSize = 7;
            ChainedIterator<StackMapFrame.VariableInfo> iter = new ChainedIterator<StackMapFrame.VariableInfo>(this.m_listLocals.iterator(), this.m_listStack.iterator());
            while (iter.hasNext()) {
                cSize += ((StackMapFrame.VariableInfo)iter.next()).size();
            }
            return cSize;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            super.disassemble(stream, pool);
            this.m_nOffset = stream.readUnsignedShort();
            int cItems = stream.readUnsignedShort();
            this.m_listLocals = new LinkedList<StackMapFrame.VariableInfo>();
            LinkedList<StackMapFrame.VariableInfo> listLocals = this.m_listLocals;
            for (int i = 0; i < cItems; ++i) {
                listLocals.add(StackMapTableAttribute.loadVariableInfo(this, stream, pool));
            }
            cItems = stream.readUnsignedShort();
            this.m_listStack = new LinkedList<StackMapFrame.VariableInfo>();
            LinkedList<StackMapFrame.VariableInfo> listStack = this.m_listStack;
            for (int i = 0; i < cItems; ++i) {
                listStack.add(StackMapTableAttribute.loadVariableInfo(this, stream, pool));
            }
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_nOffset);
            List<StackMapFrame.VariableInfo> listLocals = this.m_listLocals;
            stream.writeShort(listLocals.size());
            for (StackMapFrame.VariableInfo var : listLocals) {
                var.assemble(stream, pool);
            }
            List<StackMapFrame.VariableInfo> listStack = this.m_listStack;
            stream.writeShort(listStack.size());
            for (StackMapFrame.VariableInfo var : listStack) {
                var.assemble(stream, pool);
            }
        }
    }

    public class AppendFrame
    extends StackMapFrame {
        private int m_nOffset;
        private List<StackMapFrame.VariableInfo> m_listLocals;

        public AppendFrame(int nTag) {
            super(nTag);
        }

        public int getAppendedLocals() {
            return this.m_nTag - 251;
        }

        @Override
        public int getOffset() {
            return this.m_nOffset;
        }

        public void setOffset(int nOffset) {
            this.m_nOffset = nOffset;
        }

        @Override
        protected int size() {
            int cSize = 3;
            for (StackMapFrame.VariableInfo var : this.m_listLocals) {
                cSize += var.size();
            }
            return cSize;
        }

        public Enumeration getLocals() {
            return Collections.enumeration(this.m_listLocals);
        }

        public boolean add(int i, StackMapFrame.VariableInfo var) {
            List<StackMapFrame.VariableInfo> listVars = this.m_listLocals;
            if (this.getAppendedLocals() >= listVars.size()) {
                return false;
            }
            listVars.add(i, var);
            return true;
        }

        public boolean add(StackMapFrame.VariableInfo var) {
            List<StackMapFrame.VariableInfo> listVars = this.m_listLocals;
            if (this.getAppendedLocals() >= listVars.size()) {
                return false;
            }
            return listVars.add(var);
        }

        public StackMapFrame.VariableInfo remove(int i) {
            StackMapFrame.VariableInfo var = this.m_listLocals.remove(i);
            return var;
        }

        public boolean remove(StackMapFrame.VariableInfo var) {
            return this.m_listLocals.remove(var);
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            super.disassemble(stream, pool);
            this.m_nOffset = stream.readUnsignedShort();
            int cLocals = this.getAppendedLocals();
            this.m_listLocals = new LinkedList<StackMapFrame.VariableInfo>();
            LinkedList<StackMapFrame.VariableInfo> listLocals = this.m_listLocals;
            for (int i = 0; i < cLocals; ++i) {
                listLocals.add(StackMapTableAttribute.loadVariableInfo(this, stream, pool));
            }
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_nOffset);
            for (StackMapFrame.VariableInfo var : this.m_listLocals) {
                var.assemble(stream, pool);
            }
        }
    }

    public class ChopFrame
    extends StackMapFrame {
        private int m_nOffset;

        public ChopFrame(int nTag) {
            super(nTag);
        }

        public int getAbsentLocals() {
            return 251 - this.m_nTag;
        }

        @Override
        public int getOffset() {
            return this.m_nOffset;
        }

        public void setOffset(int nOffset) {
            this.m_nOffset = nOffset;
        }

        @Override
        protected int size() {
            return 3;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            super.disassemble(stream, pool);
            this.m_nOffset = stream.readUnsignedShort();
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_nOffset);
        }
    }

    public class SameLocalsOneStackItemFrameExtended
    extends SameLocalsOneStackItemFrame {
        private int m_nOffset;

        public SameLocalsOneStackItemFrameExtended() {
            super(247);
        }

        @Override
        public int getOffset() {
            return this.m_nOffset;
        }

        public void setOffset(int nOffset) {
            this.m_nOffset = nOffset;
        }

        @Override
        protected int size() {
            return 3 + this.m_stack.size();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            this.m_nOffset = stream.readUnsignedShort();
            super.disassemble(stream, pool);
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeByte(this.m_nTag);
            stream.writeShort(this.m_nOffset);
            if (this.m_stack != null) {
                this.m_stack.assemble(stream, pool);
            }
        }
    }

    public class SameLocalsOneStackItemFrame
    extends StackMapFrame {
        StackMapFrame.VariableInfo m_stack;

        public SameLocalsOneStackItemFrame(int nTag) {
            super(nTag);
        }

        @Override
        public int getOffset() {
            return this.m_nTag - 64;
        }

        public StackMapFrame.VariableInfo getStack() {
            return this.m_stack;
        }

        public void setStack(StackMapFrame.VariableInfo varInfo) {
            this.m_stack = varInfo;
        }

        @Override
        protected int size() {
            return 1 + this.m_stack.size();
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            super.disassemble(stream, pool);
            this.m_stack = StackMapTableAttribute.loadVariableInfo(this, stream, pool);
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            if (this.m_stack != null) {
                this.m_stack.assemble(stream, pool);
            }
        }
    }

    public class SameFrameExtended
    extends StackMapFrame {
        private int m_nOffset;

        public SameFrameExtended() {
            super(251);
        }

        @Override
        public int getOffset() {
            return this.m_nOffset;
        }

        public void setOffset(int nOffset) {
            this.m_nOffset = nOffset;
        }

        @Override
        protected int size() {
            return 3;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            super.disassemble(stream, pool);
            this.m_nOffset = stream.readUnsignedShort();
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            super.assemble(stream, pool);
            stream.writeShort(this.m_nOffset);
        }
    }

    public class SameFrame
    extends StackMapFrame {
        public SameFrame(int nTag) {
            super(nTag);
        }

        @Override
        public int getOffset() {
            return this.m_nTag;
        }

        @Override
        protected int size() {
            return 1;
        }
    }

    public abstract class StackMapFrame
    extends VMStructure
    implements Constants {
        int m_nTag;
        int m_nLength;

        public StackMapFrame(int nTag) {
            this.m_nTag = nTag;
        }

        @Override
        protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        }

        @Override
        protected void preassemble(ConstantPool pool) {
        }

        @Override
        protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
            stream.writeByte(this.m_nTag);
        }

        public abstract int getOffset();

        protected abstract int size();

        public class UninitializedVariableInfo
        extends VariableInfo {
            private int m_nOffset;

            public UninitializedVariableInfo() {
                super(VariableInfoType.Uninitialized.ordinal());
            }

            public int getOffset() {
                return this.m_nOffset;
            }

            @Override
            protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
                super.disassemble(stream, pool);
                this.m_nOffset = stream.readUnsignedShort();
            }

            @Override
            protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
                super.assemble(stream, pool);
                stream.writeShort(this.m_nOffset);
            }

            @Override
            protected int size() {
                return 3;
            }
        }

        public class ObjectVariableInfo
        extends VariableInfo {
            private Constant m_objectName;

            public ObjectVariableInfo() {
                super(VariableInfoType.Object.ordinal());
            }

            public Constant getName() {
                return this.m_objectName;
            }

            @Override
            protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
                super.disassemble(stream, pool);
                this.m_objectName = pool.getConstant(stream.readUnsignedShort());
            }

            @Override
            protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
                super.assemble(stream, pool);
                stream.writeShort(pool.findConstant(this.m_objectName));
            }

            @Override
            protected int size() {
                return 3;
            }
        }

        public class VariableInfo
        extends VMStructure
        implements Constants {
            private VariableInfoType m_type;

            public VariableInfo(int nTag) {
                this.m_type = VariableInfoType.values()[nTag];
            }

            public VariableInfoType getType() {
                return this.m_type;
            }

            @Override
            protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
            }

            @Override
            protected void preassemble(ConstantPool pool) {
            }

            @Override
            protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
                stream.writeByte(this.m_type.ordinal());
            }

            protected int size() {
                return 1;
            }
        }
    }
}

