/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Jsr;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.java.FinallyClause;
import com.tangosol.dev.compiler.java.GuardedStatement;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;

public abstract class BranchStatement
extends Statement {
    private static final String CLASS = "BranchStatement";
    private Token tokLabel;
    private Statement stmtTarget;

    protected BranchStatement(Statement stmt, Token tokFirst, Token tokLabel) {
        super(stmt, tokFirst);
        this.tokLabel = tokLabel;
    }

    protected void compileFinallyClauses(CodeAttribute code) throws CompilerException {
        Statement target = this.getTargetStatement();
        Statement prev = null;
        for (Statement stmt = this.getOuterStatement(); stmt != target; stmt = stmt.getOuterStatement()) {
            Label lblUnwind;
            if (stmt instanceof GuardedStatement && !(prev instanceof FinallyClause) && (lblUnwind = ((GuardedStatement)stmt).getUnwindLabel()) != null) {
                code.add(new Jsr(lblUnwind));
            }
            prev = stmt;
        }
    }

    public Token getLabelToken() {
        return this.tokLabel;
    }

    public String getLabelName() {
        return this.tokLabel == null ? null : this.tokLabel.getText();
    }

    public Statement getTargetStatement() {
        return this.stmtTarget;
    }

    protected void setTargetStatement(Statement stmt) {
        this.stmtTarget = stmt;
    }

    @Override
    public String toString() {
        String s = super.toString();
        if (this.getLabelName() != null) {
            s = s + " label=" + this.getLabelName();
        }
        return s;
    }
}

