/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DeclarationStatement;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;
import java.util.Set;

public class CatchClause
extends Block {
    private static final String CLASS = "CatchClause";

    public CatchClause(Statement outer, Token token) {
        super(outer, token);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        DeclarationStatement stmtDecl = this.getDeclaration();
        Statement stmtHandler = this.getBody();
        DualSet setUBlockVars = new DualSet(setUVars);
        DualSet setFBlockVars = new DualSet(setFVars);
        stmtDecl.precompile(ctx, setUBlockVars, setFBlockVars, mapThrown, errlist);
        if (!stmtDecl.isSingleDeclaration() || stmtDecl.isAssignmentDeclaration()) {
            this.logError(3, "JC-012", null, errlist);
        }
        if (stmtDecl.isFinal()) {
            setFBlockVars.add(stmtDecl.getVariable());
        }
        stmtHandler.precompile(ctx, setUBlockVars, setFBlockVars, mapThrown, errlist);
        setUVars.removeAll(setUBlockVars.getRemoved());
        Set setAssigned = setFBlockVars.getAdded();
        if (!setAssigned.isEmpty()) {
            setAssigned.retainAll(this.getBlock().getVariables());
            if (!setAssigned.isEmpty()) {
                setFVars.addAll(setAssigned);
            }
        }
        return this;
    }

    @Override
    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        DeclarationStatement stmtDecl = this.getDeclaration();
        Statement stmtHandler = this.getBody();
        boolean fCompletes = fReached;
        code.add(new Begin());
        fCompletes &= stmtDecl.compile(ctx, code, fReached, errlist);
        code.add(new Astore((Avar)stmtDecl.getVariable().getOp()));
        code.add(new End());
        return fCompletes &= stmtHandler.compile(ctx, code, fReached, errlist);
    }

    public DeclarationStatement getDeclaration() {
        return (DeclarationStatement)this.getInnerStatement();
    }

    public Statement getBody() {
        return this.getInnerStatement().getNextStatement();
    }

    public DataType getExceptionType() {
        return this.getDeclaration().getTypeExpression().getType();
    }

    public ClassConstant getExceptionClass() {
        return new ClassConstant(this.getExceptionType().getClassName());
    }
}

