/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class ExpressionStatement
extends Statement {
    private static final String CLASS = "ExpressionStatement";
    private Expression expr;

    public ExpressionStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.expr;
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        expr.setDiscarded(true);
        this.expr = expr;
        setUVars.merge();
        setFVars.merge();
        return this;
    }

    @Override
    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        this.expr.compile(ctx, code, fReached, errlist);
        return fReached;
    }

    public Expression getExpression() {
        return this.expr;
    }

    protected void setExpression(Expression expr) {
        this.expr = expr;
    }

    @Override
    public void print(String sIndent) {
        ExpressionStatement.out(sIndent + this.toString());
        ExpressionStatement.out(sIndent + "  Expression:");
        this.expr.print(sIndent + "    ");
    }
}

