/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Ixor;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class NotExpression
extends UnaryExpression {
    private static final String CLASS = "NotExpression";
    private static final IntConstant FALSE = Constants.CONSTANT_ICONST_0;
    private static final IntConstant TRUE = Constants.CONSTANT_ICONST_1;

    public NotExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        expr.checkBoolean(errlist);
        this.setExpression(expr);
        this.setType(DataType.BOOLEAN);
        setUVars.negate();
        setFVars.negate();
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        if (!ctx.isDebug() && expr.isConstant()) {
            boolean fVal = (Boolean)expr.getValue();
            code.add(new Iconst(fVal ? FALSE : TRUE));
        } else {
            expr.compile(ctx, code, fReached, errlist);
            code.add(new Iconst(TRUE));
            code.add(new Ixor());
        }
        return fReached;
    }

    @Override
    public boolean isConstant() {
        return this.getExpression().isConstant();
    }

    @Override
    public Object getValue() {
        Expression expr = this.getExpression();
        boolean fVal = (Boolean)expr.getValue();
        return fVal ? Boolean.FALSE : Boolean.TRUE;
    }
}

