/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Ifeq;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.LogicalExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.AbstractSet;
import java.util.Map;

public class OrExpression
extends LogicalExpression {
    private static final String CLASS = "OrExpression";
    private static final IntConstant TRUE = Constants.CONSTANT_ICONST_1;
    private static final IntConstant FALSE = Constants.CONSTANT_ICONST_0;

    public OrExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        DualSet setUFalse = new DualSet(setUVars.getFalseSet());
        DualSet setFFalse = new DualSet(setFVars.getFalseSet());
        right = (Expression)right.precompile(ctx, setUFalse, setFFalse, mapThrown, errlist);
        if (setUFalse.isModified()) {
            if (!setUFalse.isSingle()) {
                setUFalse.getTrueSet().clear();
            }
            setUFalse.resolve();
        }
        if (!setUVars.isModified()) {
            setUVars.merge();
        }
        if (setFVars.isModified() || setFFalse.isModified()) {
            AbstractSet setFRightTrue = setFFalse.isSingle() ? setFFalse : setFFalse.getTrueSet();
            setFVars.getTrueSet().addAll(setFRightTrue);
            if (!setFFalse.isSingle()) {
                setFFalse.getTrueSet().clear();
            }
            setFFalse.resolve();
        }
        if (!setFVars.isModified()) {
            setFVars.merge();
        }
        left.checkBoolean(errlist);
        right.checkBoolean(errlist);
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(DataType.BOOLEAN);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (!ctx.isDebug() && this.isConstant()) {
            boolean fVal = (Boolean)this.getValue();
            code.add(new Iconst(fVal ? TRUE : FALSE));
            if (fReached && !right.isConstant()) {
                right.notReached(errlist);
            }
        } else {
            Label lblRight = new Label();
            Label lblExit = new Label();
            left.compile(ctx, code, fReached, errlist);
            code.add(new Ifeq(lblRight));
            code.add(new Iconst(TRUE));
            code.add(new Goto(lblExit));
            code.add(lblRight);
            right.compile(ctx, code, fReached, errlist);
            code.add(lblExit);
        }
        return fReached;
    }

    @Override
    public boolean isConstant() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (left.isConstant()) {
            boolean fLeft = (Boolean)left.getValue();
            return fLeft || right.isConstant();
        }
        return false;
    }

    @Override
    public Object getValue() {
        Expression left = this.getLeftExpression();
        if (((Boolean)left.getValue()).booleanValue()) {
            return Boolean.TRUE;
        }
        Expression right = this.getRightExpression();
        if (((Boolean)right.getValue()).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

