/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.CompilerErrorInfo;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.ParsePosition;
import com.tangosol.dev.compiler.Script;
import com.tangosol.dev.compiler.Token;
import com.tangosol.dev.compiler.java.Constants;
import com.tangosol.dev.compiler.java.LiteralToken;
import com.tangosol.dev.compiler.java.UnicodeDataFormatException;
import com.tangosol.dev.compiler.java.UnicodeScript;
import com.tangosol.util.Base;
import com.tangosol.util.Dequeue;
import com.tangosol.util.ErrorList;
import com.tangosol.util.HashHelper;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;

public class Tokenizer
extends Base
implements com.tangosol.dev.compiler.Tokenizer,
Constants {
    public static final LiteralToken LIT_ZERO = new LiteralToken(0, -1, -1, -1);
    public static final LiteralToken LIT_ZERO_L = new LiteralToken(0L, -1, -1, -1);
    public static final LiteralToken LIT_ZERO_F = new LiteralToken(0.0f, -1, -1, -1);
    public static final LiteralToken LIT_ZERO_D = new LiteralToken(0.0, -1, -1, -1);
    public static final String MAX_INT = "-2147483648";
    public static final String MAX_LONG = "-9223372036854775808";
    private Script m_script;
    private Hashtable m_tblNames;
    private Dequeue m_dq;
    private ErrorList m_errlist;
    private boolean m_fExtensionsEnabled;
    private boolean m_fCommentsEnabled;

    public Tokenizer() {
        this.initOptions(null);
    }

    public Tokenizer(String s, int iLine, ErrorList errlist) throws CompilerException {
        this(s, iLine, errlist, null);
    }

    public Tokenizer(String s, ErrorList errlist, Properties propOpts) throws CompilerException {
        this(s, 0, errlist, propOpts);
    }

    public Tokenizer(String s, int iLine, ErrorList errlist, Properties propOpts) throws CompilerException {
        this.initOptions(propOpts);
        this.setScript(new UnicodeScript(s, iLine), errlist);
    }

    private void initOptions(Properties propOpts) {
        this.m_fExtensionsEnabled = true;
        this.m_fCommentsEnabled = false;
        if (propOpts != null) {
            this.m_fExtensionsEnabled = Tokenizer.extractBooleanOption(propOpts, "java.tokenizer.extensions", this.m_fExtensionsEnabled);
            this.m_fCommentsEnabled = Tokenizer.extractBooleanOption(propOpts, "java.tokenizer.comments", this.m_fCommentsEnabled);
        }
    }

    private static boolean extractBooleanOption(Properties propOpts, String sName, boolean fDefault) {
        String sValue = propOpts.getProperty(sName);
        if (sValue != null && sValue.length() > 0) {
            switch (sValue.trim().charAt(0)) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    return true;
                }
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    return false;
                }
            }
        }
        return fDefault;
    }

    public boolean isExtensionsEnabled() {
        return this.m_fExtensionsEnabled;
    }

    public void setExtensionsEnabled(boolean f) {
        this.m_fExtensionsEnabled = f;
    }

    public boolean isCommentsEnabled() {
        return this.m_fCommentsEnabled;
    }

    public void setCommentsEnabled(boolean f) {
        this.m_fCommentsEnabled = f;
    }

    @Override
    public void setScript(Script script, ErrorList errlist) throws CompilerException {
        if (this.m_script != null) {
            throw new IllegalStateException();
        }
        this.m_errlist = errlist;
        this.m_script = script;
        this.m_tblNames = new Hashtable();
        this.m_dq = new Dequeue();
        this.eatFluff();
    }

    @Override
    public boolean hasMoreTokens() {
        if (this.m_dq.hasMoreElements()) {
            return true;
        }
        return this.m_script.hasMoreChars();
    }

    @Override
    public Token nextToken() throws CompilerException {
        com.tangosol.dev.compiler.java.Token tok;
        if (this.m_dq.hasMoreElements()) {
            tok = (com.tangosol.dev.compiler.java.Token)this.m_dq.nextElement();
        } else if (this.m_script.hasMoreChars()) {
            tok = this.eatToken();
            this.eatFluff();
        } else {
            throw new NoSuchElementException();
        }
        return tok;
    }

    @Override
    public void putBackToken(Token tok) {
        this.m_dq.putBackElement(tok);
    }

    @Override
    public ParsePosition savePosition() {
        Position pos = new Position();
        pos.toker = this;
        pos.dq = (Dequeue)this.m_dq.clone();
        pos.scriptpos = this.m_script.savePosition();
        return pos;
    }

    @Override
    public void restorePosition(ParsePosition parsepos) {
        Position pos = (Position)parsepos;
        if (pos.toker != this) {
            throw new IllegalArgumentException("Unknown ParsePosition object!");
        }
        this.m_script.restorePosition(pos.scriptpos);
        this.m_dq = pos.dq;
    }

    public int getLine() {
        return this.m_script.getLine();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void eatFluff() throws CompilerException {
        try {
            block10: while (this.m_script.hasMoreChars()) {
                char ch = this.m_script.nextChar();
                switch (ch) {
                    case '\n': {
                        continue block10;
                    }
                    case '\u001a': {
                        continue block10;
                    }
                    case '\t': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        continue block10;
                    }
                    case '/': {
                        ch = this.m_script.nextChar();
                        if (ch == '*') {
                            this.eatMultiLineComment();
                            continue block10;
                        }
                        if (ch != '/') {
                            this.m_script.putBackChar();
                            this.m_script.putBackChar();
                            return;
                        }
                        this.eatSingleLineComment();
                        continue block10;
                    }
                }
            }
            return;
            this.m_script.putBackChar();
            return;
        }
        catch (EOFException e) {
            this.logError(3, "JT-002", null, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (UnicodeDataFormatException e) {
            this.logError(3, "JT-003", null, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, "JT-011", new String[]{e.toString()}, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected void eatMultiLineComment() throws IOException {
        while (true) {
            if (this.m_script.nextChar() != '*') {
                continue;
            }
            if (this.m_script.nextChar() == '/') {
                return;
            }
            this.m_script.putBackChar();
        }
    }

    protected void eatSingleLineComment() throws IOException {
        while (this.m_script.hasMoreChars()) {
            char ch = this.m_script.nextChar();
            if (ch != '\r' && ch != '\n') continue;
            this.m_script.putBackChar();
            return;
        }
    }

    protected com.tangosol.dev.compiler.java.Token eatToken() throws CompilerException {
        try {
            while (true) {
                int iLine = this.m_script.getLine();
                int ofInLine = this.m_script.getOffset();
                char ch = this.m_script.nextChar();
                switch (ch) {
                    case '(': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_LPARENTHESIS, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case ')': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_RPARENTHESIS, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '{': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_LCURLYBRACE, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '}': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_RCURLYBRACE, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '[': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_LBRACKET, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case ']': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_RBRACKET, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case ';': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_SEMICOLON, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case ',': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_COMMA, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '.': {
                        boolean fNum = Tokenizer.isDecimal(this.m_script.nextChar());
                        this.m_script.putBackChar();
                        if (fNum) {
                            this.m_script.putBackChar();
                            return this.eatFloatingPointLiteral();
                        }
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_DOT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '~': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_BITNOT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '?': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_CONDITIONAL, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case ':': {
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_COLON, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '+': {
                        switch (this.m_script.nextChar()) {
                            case '+': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_INCREMENT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            case '=': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_ADD, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ADD, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '-': {
                        switch (this.m_script.nextChar()) {
                            case '-': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_DECREMENT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            case '=': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_SUB, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_SUB, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '*': {
                        if (this.m_script.nextChar() == '=') {
                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_MUL, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_MUL, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '/': {
                        if (this.m_script.nextChar() == '=') {
                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_DIV, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_DIV, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '%': {
                        if (this.m_script.nextChar() == '=') {
                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_REM, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_REM, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '^': {
                        if (this.m_script.nextChar() == '=') {
                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_BITXOR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_BITXOR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '=': {
                        if (this.m_script.nextChar() == '=') {
                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_TEST_EQ, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '!': {
                        if (this.m_script.nextChar() == '=') {
                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_TEST_NE, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_LOGICAL_NOT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '&': {
                        switch (this.m_script.nextChar()) {
                            case '&': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_LOGICAL_AND, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            case '=': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_BITAND, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_BITAND, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '|': {
                        switch (this.m_script.nextChar()) {
                            case '|': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_LOGICAL_OR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            case '=': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_BITOR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_BITOR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '<': {
                        switch (this.m_script.nextChar()) {
                            case '=': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_TEST_LE, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            case '<': {
                                if (this.m_script.nextChar() == '=') {
                                    return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_SHL, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                                }
                                this.m_script.putBackChar();
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_SHL, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_TEST_LT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '>': {
                        switch (this.m_script.nextChar()) {
                            case '=': {
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_TEST_GE, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            case '>': {
                                switch (this.m_script.nextChar()) {
                                    case '>': {
                                        if (this.m_script.nextChar() == '=') {
                                            return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_USHR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                                        }
                                        this.m_script.putBackChar();
                                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_USHR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                                    }
                                    case '=': {
                                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_ASSIGN_SHR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                                    }
                                }
                                this.m_script.putBackChar();
                                return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_SHR, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                        }
                        this.m_script.putBackChar();
                        return new com.tangosol.dev.compiler.java.Token(com.tangosol.dev.compiler.java.Token.TOK_TEST_GT, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    case '\'': {
                        this.m_script.putBackChar();
                        return this.eatCharacterLiteral();
                    }
                    case '\"': 
                    case '`': {
                        this.m_script.putBackChar();
                        return this.eatStringLiteral();
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.m_script.putBackChar();
                        return this.eatNumericLiteral();
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.m_script.putBackChar();
                        return this.eatIdentifierOrKeyword();
                    }
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    this.m_script.putBackChar();
                    return this.eatIdentifierOrKeyword();
                }
                this.logError(3, "JT-004", new String[]{LiteralToken.printableChar(ch)}, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                this.eatFluff();
            }
        }
        catch (EOFException e) {
            this.logError(3, "JT-002", null, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
        catch (IOException e) {
            this.logError(3, "JT-011", new String[]{e.toString()}, this.m_script.getLine(), this.m_script.getOffset(), 0);
            throw new CompilerException();
        }
    }

    protected com.tangosol.dev.compiler.java.Token eatCharacterLiteral() throws CompilerException, IOException {
        int iLine = this.m_script.getLine();
        int ofInLine = this.m_script.getOffset();
        this.m_script.nextChar();
        char ch = this.m_script.nextChar();
        switch (ch) {
            case '\\': {
                this.m_script.putBackChar();
                ch = this.eatEscapedCharacter();
                break;
            }
            case '\n': 
            case '\r': {
                this.m_script.putBackChar();
                this.logError(3, "JT-008", null, iLine, this.m_script.getOffset(), 0);
                return new LiteralToken(' ', iLine, ofInLine, this.m_script.getOffset() - ofInLine);
            }
            case '\'': {
                this.m_script.putBackChar();
                int ofSQuote = this.m_script.getOffset();
                this.m_script.nextChar();
                this.logError(3, "JT-007", null, iLine, ofSQuote, this.m_script.getOffset() - ofSQuote);
            }
        }
        if (this.m_script.nextChar() != '\'') {
            this.m_script.putBackChar();
            this.logError(3, "JT-006", null, iLine, this.m_script.getOffset(), 0);
        }
        return new LiteralToken(ch, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
    }

    protected com.tangosol.dev.compiler.java.Token eatStringLiteral() throws CompilerException, IOException {
        int iLine = this.m_script.getLine();
        int ofInLine = this.m_script.getOffset();
        char chQuote = this.m_script.nextChar();
        StringBuffer sb = new StringBuffer();
        char ch = this.m_script.nextChar();
        while (ch != chQuote) {
            if (ch == '\\') {
                this.m_script.putBackChar();
                ch = this.eatEscapedCharacter();
            } else if (ch == '\r' || ch == '\n') {
                this.m_script.putBackChar();
                this.logError(3, "JT-008", null, iLine, this.m_script.getOffset(), 0);
                break;
            }
            sb.append(ch);
            ch = this.m_script.nextChar();
        }
        String s = sb.toString();
        if (chQuote == '`') {
            s = HashHelper.hash(s);
        }
        return new LiteralToken(s, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
    }

    public char eatEscapedCharacter() throws CompilerException, IOException {
        this.m_script.nextChar();
        char ch = this.m_script.nextChar();
        switch (ch) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '\'': 
            case '\\': {
                return ch;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int cMaxDigits = ch > '3' ? 2 : 3;
                int nChar = 0;
                do {
                    nChar = nChar * 8 + (ch - 48);
                } while ((ch = this.m_script.nextChar()) >= '0' && ch <= '7' && --cMaxDigits > 0);
                this.m_script.putBackChar();
                ch = (char)nChar;
                return ch;
            }
            case '\n': 
            case '\r': {
                this.m_script.putBackChar();
                this.logError(3, "JT-008", null, this.m_script.getLine(), this.m_script.getOffset(), 0);
                return ' ';
            }
        }
        int ofNext = this.m_script.getOffset();
        this.m_script.putBackChar();
        this.logError(3, "JT-005", new String[]{LiteralToken.printableChar(ch)}, this.m_script.getLine(), this.m_script.getOffset(), ofNext - this.m_script.getOffset());
        this.m_script.nextChar();
        return ' ';
    }

    protected com.tangosol.dev.compiler.java.Token eatNumericLiteral() throws CompilerException, IOException {
        ParsePosition pos = this.m_script.savePosition();
        com.tangosol.dev.compiler.java.Token tok = this.eatIntegralLiteral();
        if (tok == null) {
            this.m_script.restorePosition(pos);
            tok = this.eatFloatingPointLiteral();
        }
        return tok;
    }

    protected com.tangosol.dev.compiler.java.Token eatIntegralLiteral() throws CompilerException, IOException {
        int iLine = this.m_script.getLine();
        int ofInLine = this.m_script.getOffset();
        char ch = this.m_script.nextChar();
        if (ch == '0') {
            ch = this.m_script.nextChar();
            switch (ch) {
                case 'X': 
                case 'x': {
                    boolean fLong;
                    StringBuffer sb = new StringBuffer();
                    boolean fLeadZero = true;
                    boolean fHasDigits = false;
                    ch = this.m_script.nextChar();
                    while (Tokenizer.isHex(ch)) {
                        if (ch != '0') {
                            fLeadZero = false;
                        }
                        if (!fLeadZero) {
                            sb.append(ch);
                        }
                        fHasDigits = true;
                        ch = this.m_script.nextChar();
                    }
                    boolean bl = fLong = ch == 'L' || ch == 'l';
                    if (!fLong) {
                        this.m_script.putBackChar();
                    }
                    String s = sb.toString();
                    if (!fHasDigits || s.length() > (fLong ? 16 : 8)) {
                        String sCode = fHasDigits ? "JT-009" : "JT-010";
                        this.logError(3, sCode, new String[]{s}, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    } else if (s.length() > 0) {
                        try {
                            char[] ach = s.toCharArray();
                            if (fLong) {
                                long lValue = 0L;
                                int cch = ach.length;
                                for (int of = 0; of < cch; ++of) {
                                    lValue = (lValue << 4) + (long)Tokenizer.hexValue(ach[of]);
                                }
                                return new LiteralToken(lValue, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            int nValue = 0;
                            int cch = ach.length;
                            for (int of = 0; of < cch; ++of) {
                                nValue = (nValue << 4) + Tokenizer.hexValue(ach[of]);
                            }
                            return new LiteralToken(nValue, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        catch (NumberFormatException e) {
                            this.internalError();
                        }
                    }
                    return new LiteralToken(fLong ? LIT_ZERO_L : LIT_ZERO, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    StringBuffer sb = new StringBuffer();
                    boolean fLong = false;
                    boolean fLeadZero = true;
                    while (ch >= '0' && ch <= '7') {
                        if (ch != '0') {
                            fLeadZero = false;
                        }
                        if (!fLeadZero) {
                            sb.append(ch);
                        }
                        ch = this.m_script.nextChar();
                    }
                    switch (ch) {
                        case '.': 
                        case '8': 
                        case '9': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            return null;
                        }
                        case 'L': 
                        case 'l': {
                            this.m_script.putBackChar();
                            fLong = true;
                        }
                    }
                    String s = sb.toString();
                    if (s.length() >= (fLong ? 22 : 11) && (s.length() > (fLong ? 22 : 11) || s.charAt(0) > '1')) {
                        this.logError(3, "JT-009", new String[]{s}, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    } else if (s.length() > 0) {
                        try {
                            if (fLong) {
                                return new LiteralToken(Long.parseLong(s, 8), iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                            }
                            return new LiteralToken(Integer.parseInt(s, 8), iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                        }
                        catch (NumberFormatException e) {
                            this.internalError();
                        }
                    }
                    return new LiteralToken(fLong ? LIT_ZERO_L : LIT_ZERO, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                }
                case '.': 
                case '8': 
                case '9': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return null;
                }
                case 'L': 
                case 'l': {
                    return new LiteralToken(LIT_ZERO_L, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                }
            }
            this.m_script.putBackChar();
            return new LiteralToken(LIT_ZERO, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
        }
        if (ch >= '1' && ch <= '9') {
            String sMax;
            StringBuffer sb = new StringBuffer();
            sb.append('-');
            while (ch >= '0' && ch <= '9') {
                sb.append(ch);
                ch = this.m_script.nextChar();
            }
            boolean fLong = false;
            switch (ch) {
                case '.': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return null;
                }
                case 'L': 
                case 'l': {
                    fLong = true;
                    break;
                }
                default: {
                    this.m_script.putBackChar();
                }
            }
            String s = sb.toString();
            String string = sMax = fLong ? MAX_LONG : MAX_INT;
            if (s.length() >= sMax.length() && (s.length() > sMax.length() || s.compareTo(sMax) > 0)) {
                this.logError(3, "JT-009", new String[]{s}, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
            } else {
                try {
                    if (fLong) {
                        return new LiteralToken(Long.parseLong(s, 10), true, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                    }
                    return new LiteralToken(Integer.parseInt(s, 10), true, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                }
                catch (NumberFormatException e) {
                    this.internalError();
                }
            }
            return new LiteralToken(fLong ? LIT_ZERO_L : LIT_ZERO, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
        }
        return null;
    }

    protected com.tangosol.dev.compiler.java.Token eatFloatingPointLiteral() throws CompilerException, IOException {
        int iLine = this.m_script.getLine();
        int ofInLine = this.m_script.getOffset();
        boolean fLeadingDigits = false;
        boolean fDot = false;
        boolean fTrailingDigits = false;
        boolean fExponent = false;
        boolean fExponentDigits = false;
        boolean fSuffix = false;
        boolean fFloatNotDouble = false;
        StringBuffer sb = new StringBuffer();
        char ch = this.m_script.nextChar();
        while (Tokenizer.isDecimal(ch)) {
            fLeadingDigits = true;
            sb.append(ch);
            ch = this.m_script.nextChar();
        }
        if (ch == '.') {
            fDot = true;
            sb.append(ch);
            ch = this.m_script.nextChar();
        }
        while (Tokenizer.isDecimal(ch)) {
            fTrailingDigits = true;
            sb.append(ch);
            ch = this.m_script.nextChar();
        }
        if (ch == 'E' || ch == 'e') {
            fExponent = true;
            sb.append(ch);
            ch = this.m_script.nextChar();
            if (ch == '+' || ch == '-') {
                sb.append(ch);
                ch = this.m_script.nextChar();
            }
            while (Tokenizer.isDecimal(ch)) {
                fExponentDigits = true;
                sb.append(ch);
                ch = this.m_script.nextChar();
            }
        }
        if (ch == 'D' || ch == 'd') {
            fSuffix = true;
        } else if (ch == 'F' || ch == 'f') {
            fSuffix = true;
            fFloatNotDouble = true;
        } else {
            this.m_script.putBackChar();
        }
        String s = sb.toString();
        if ((fTrailingDigits || fLeadingDigits && (fDot || fExponent || fSuffix)) && (!fExponent || fExponent && fExponentDigits)) {
            try {
                if (fFloatNotDouble) {
                    return new LiteralToken(Float.valueOf(s).floatValue(), iLine, ofInLine, this.m_script.getOffset() - ofInLine);
                }
                return new LiteralToken(Double.valueOf(s), iLine, ofInLine, this.m_script.getOffset() - ofInLine);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.logError(3, "JT-010", new String[]{s}, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
        return new LiteralToken(fFloatNotDouble ? LIT_ZERO_F : LIT_ZERO_D, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
    }

    protected com.tangosol.dev.compiler.java.Token eatIdentifierOrKeyword() throws CompilerException, IOException {
        int iLine = this.m_script.getLine();
        int ofInLine = this.m_script.getOffset();
        StringBuffer sb = new StringBuffer();
        char ch = this.m_script.nextChar();
        while (Character.isJavaIdentifierPart(ch)) {
            sb.append(ch);
            ch = this.m_script.nextChar();
        }
        this.m_script.putBackChar();
        String s = sb.toString();
        com.tangosol.dev.compiler.java.Token tok = (com.tangosol.dev.compiler.java.Token)com.tangosol.dev.compiler.java.Token.RESERVED.get(s);
        if (tok != null && !this.m_fExtensionsEnabled && tok.getID() == 2) {
            tok = null;
        }
        if (tok == null && (tok = (com.tangosol.dev.compiler.java.Token)this.m_tblNames.get(s)) == null) {
            tok = new com.tangosol.dev.compiler.java.Token(1, 0, 105, null, s);
            this.m_tblNames.put(s, tok);
        }
        return new com.tangosol.dev.compiler.java.Token(tok, iLine, ofInLine, this.m_script.getOffset() - ofInLine);
    }

    protected void internalError() throws CompilerException {
        this.logError(4, "JT-001", null, this.m_script.getLine(), this.m_script.getOffset(), 0);
        throw new CompilerException();
    }

    protected void logError(int nSeverity, String sCode, String[] asParams, int iLine, int ofInLine, int cchText) throws CompilerException {
        try {
            this.m_errlist.add(new CompilerErrorInfo(nSeverity, sCode, RESOURCES, asParams, iLine, ofInLine, cchText));
        }
        catch (ErrorList.OverflowException e) {
            throw new CompilerException();
        }
    }

    class Position
    implements ParsePosition {
        Tokenizer toker;
        Dequeue dq;
        ParsePosition scriptpos;

        Position() {
        }
    }
}

