/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.Access;
import com.tangosol.dev.disassembler.Attribute;
import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.UtfConstant;
import java.io.DataInput;
import java.io.IOException;
import java.util.Vector;

public class Member
extends Access {
    private int m_iName;
    private int m_iSig;
    private Attribute[] m_aAttr;
    protected Constant[] m_aconst;

    public Member(DataInput stream, Constant[] aconst) throws IOException {
        super(stream);
        this.m_iName = stream.readUnsignedShort();
        this.m_iSig = stream.readUnsignedShort();
        this.m_aAttr = Attribute.readAttributes(stream, aconst);
        this.m_aconst = aconst;
    }

    public int getNameIndex() {
        return this.m_iName;
    }

    public String getName() {
        return ((UtfConstant)this.m_aconst[this.m_iName]).getText();
    }

    public int getSignatureIndex() {
        return this.m_iSig;
    }

    public String getSignature() {
        return ((UtfConstant)this.m_aconst[this.m_iSig]).getText();
    }

    public Attribute[] getAttributes() {
        return (Attribute[])this.m_aAttr.clone();
    }

    public int getAttributeCount() {
        return this.m_aAttr.length;
    }

    public Attribute getAttribute(int i) {
        return this.m_aAttr[i];
    }

    public Attribute getAttribute(String sAttr) {
        for (Attribute attr : this.m_aAttr) {
            if (!sAttr.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public static String[] getParameters(String sSig) {
        char[] ach = sSig.toCharArray();
        if (ach[0] != '(') {
            throw new IllegalArgumentException("JVM Method Signature must start with '('");
        }
        Vector<String> vect = new Vector<String>();
        vect.addElement(null);
        int of = 1;
        while (ach[of] != ')') {
            int cch = Member.getTypeLength(ach, of);
            vect.addElement(new String(ach, of, cch));
            of += cch;
        }
        vect.setElementAt(new String(ach, ++of, ach.length - of), 0);
        Object[] asSig = new String[vect.size()];
        vect.copyInto(asSig);
        return asSig;
    }

    private static int getTypeLength(char[] ach, int of) {
        switch (ach[of]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                int cch = 1;
                while (Member.isDecimal(ach[++of])) {
                    ++cch;
                }
                return cch + Member.getTypeLength(ach, of);
            }
            case 'L': {
                int cch = 2;
                while (ach[++of] != ';') {
                    ++cch;
                }
                return cch;
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + ach[of] + "'");
    }

    public static String getType(String sSig) {
        switch (sSig.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'L': {
                return sSig.substring(1, sSig.indexOf(59)).replace('/', '.');
            }
            case '[': {
                if (Member.isDecimal(sSig.charAt(1))) {
                    int n = 0;
                    int of = 1;
                    char ch = sSig.charAt(of);
                    while (Member.isDecimal(ch)) {
                        n = n * 10 + Member.decimalValue(ch);
                        ch = sSig.charAt(++of);
                    }
                    return Member.getType(sSig.substring(of)) + "[" + n + "]";
                }
                return Member.getType(sSig.substring(1)) + "[]";
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + sSig.charAt(0) + "'");
    }
}

