/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.introspect;

import com.tangosol.dev.introspect.ClassAnnotationScanner;
import com.tangosol.dev.introspect.ClassPathResourceDiscoverer;
import com.tangosol.dev.introspect.ResourceDiscoverer;
import com.tangosol.dev.introspect.UrlScanner;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.InFilter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public class ClassAnnotationSeeker {
    protected Dependencies m_deps;

    public ClassAnnotationSeeker(Dependencies deps) {
        Base.azzert(deps != null, "ClassAnnotationSeeker requires dependencies");
        this.m_deps = deps.clone();
    }

    public <A extends Annotation> Set<String> findClassNames(Class<A> clzAnno) {
        Dependencies deps = this.m_deps;
        Set<String> setPackages = this.convertPackage(deps.getPackages());
        ClassLoader loader = deps.getContextClassLoader();
        ResourceDiscoverer<String> discoverer = deps.getDiscoverer();
        UrlScanner<String> scanner = deps.getScanner();
        discoverer.setContextClassLoader(loader);
        scanner.setContextClassLoader(loader);
        scanner.setFilter(this.wrapFilter(deps.getFilter(), clzAnno));
        return scanner.scan(discoverer.discover(deps.getDiscriminator(), setPackages));
    }

    public Dependencies getDependencies() {
        return this.m_deps;
    }

    public void setDependencies(Dependencies deps) {
        this.m_deps = deps;
    }

    protected Filter wrapFilter(Filter filter, Class<? extends Annotation> ... aclzAnno) {
        HashSet<String> listAnnoNames = new HashSet<String>(aclzAnno.length);
        for (int i = 0; i < aclzAnno.length; ++i) {
            listAnnoNames.add(aclzAnno[i].getName());
        }
        InFilter filterNew = new InFilter(IdentityExtractor.INSTANCE, listAnnoNames);
        return filter == null ? filterNew : new AndFilter(filter, filterNew);
    }

    protected Set<String> convertPackage(Set<String> setPackages) {
        HashSet<String> setResources = new HashSet<String>(setPackages.size());
        for (String sPackage : setPackages) {
            setResources.add(this.convertPackage(sPackage));
        }
        return setResources;
    }

    protected String convertPackage(String sBasePackage) {
        Base.azzert(sBasePackage != null, "base-package can not be null when using AnnotationSeeker");
        if (sBasePackage.isEmpty()) {
            return sBasePackage;
        }
        StringBuilder sNormalized = new StringBuilder(sBasePackage.trim().replace('.', '/'));
        int cNormalized = sNormalized.length();
        return sNormalized.substring(sNormalized.charAt(0) == '/' ? 1 : 0, sNormalized.charAt(cNormalized - 1) == '/' ? cNormalized - 1 : cNormalized);
    }

    public static class Dependencies
    implements ClassLoaderAware {
        protected String m_sDiscriminator = "";
        protected Set<String> m_setPackages = new HashSet<String>();
        protected Filter m_filter;
        protected ResourceDiscoverer<String> m_discoverer;
        protected UrlScanner<String> m_scanner;
        protected ClassLoader m_loader;

        public Dependencies() {
            this.m_filter = AlwaysFilter.INSTANCE;
            this.m_discoverer = new ClassPathResourceDiscoverer();
            this.m_scanner = new ClassAnnotationScanner();
        }

        public Dependencies(Dependencies deps) {
            this.m_loader = deps.getContextClassLoader();
            this.m_discoverer = deps.getDiscoverer();
            this.m_sDiscriminator = deps.getDiscriminator();
            this.m_filter = deps.getFilter();
            this.m_setPackages = new HashSet<String>(deps.getPackages());
            this.m_scanner = deps.getScanner();
        }

        @Override
        public ClassLoader getContextClassLoader() {
            ClassLoader loader = this.m_loader;
            if (loader == null) {
                loader = this.m_loader = Base.getContextClassLoader();
            }
            return loader;
        }

        @Override
        public void setContextClassLoader(ClassLoader loader) {
            this.m_loader = loader;
            ResourceDiscoverer<String> discoverer = this.m_discoverer;
            UrlScanner<String> scanner = this.m_scanner;
            if (discoverer != null) {
                discoverer.setContextClassLoader(loader);
            }
            if (scanner != null) {
                scanner.setContextClassLoader(loader);
            }
        }

        public String getDiscriminator() {
            return this.m_sDiscriminator;
        }

        public Dependencies setDiscriminator(String sDiscriminator) {
            this.m_sDiscriminator = sDiscriminator;
            return this;
        }

        public Set<String> getPackages() {
            return this.m_setPackages;
        }

        public Dependencies setPackages(Set<String> setPackages) {
            Base.azzert(setPackages != null, "Set of packages must have a value");
            this.m_setPackages = setPackages;
            return this;
        }

        public Dependencies addPackage(String sPackage) {
            Set<String> setPackages = this.m_setPackages;
            setPackages.add(sPackage);
            return this;
        }

        public Filter getFilter() {
            return this.m_filter;
        }

        public Dependencies setFilter(Filter filter) {
            this.m_filter = filter;
            return this;
        }

        public ResourceDiscoverer<String> getDiscoverer() {
            return this.m_discoverer;
        }

        public Dependencies setDiscoverer(ResourceDiscoverer<String> discoverer) {
            this.m_discoverer = discoverer;
            return this;
        }

        public UrlScanner<String> getScanner() {
            return this.m_scanner;
        }

        public Dependencies setScanner(UrlScanner<String> scanner) {
            this.m_scanner = scanner;
            return this;
        }

        protected Dependencies clone() {
            return new Dependencies(this);
        }
    }
}

