/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.codemodel;

import com.tangosol.internal.codemodel.JAnnotatable;
import com.tangosol.internal.codemodel.JAnnotationStringValue;
import com.tangosol.internal.codemodel.JAnnotationUse;
import com.tangosol.internal.codemodel.JAnnotationValue;
import com.tangosol.internal.codemodel.JAnnotationWriter;
import com.tangosol.internal.codemodel.JClass;
import com.tangosol.internal.codemodel.JCodeModel;
import com.tangosol.internal.codemodel.JEnumConstant;
import com.tangosol.internal.codemodel.JExpr;
import com.tangosol.internal.codemodel.JExpression;
import com.tangosol.internal.codemodel.JExpressionImpl;
import com.tangosol.internal.codemodel.JFormatter;
import com.tangosol.internal.codemodel.JType;
import com.tangosol.internal.codemodel.TypedAnnotationWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAnnotationArrayMember
extends JAnnotationValue
implements JAnnotatable {
    private final List<JAnnotationValue> values = new ArrayList<JAnnotationValue>();
    private final JCodeModel owner;

    JAnnotationArrayMember(JCodeModel owner) {
        this.owner = owner;
    }

    public JAnnotationArrayMember param(String value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(boolean value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(byte value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(char value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(double value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(long value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(short value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(int value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(float value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(final Enum<?> value) {
        JAnnotationValue annotationValue = new JAnnotationValue(){

            public void generate(JFormatter f) {
                f.t(JAnnotationArrayMember.this.owner.ref(value.getDeclaringClass())).p('.').p(value.name());
            }
        };
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JEnumConstant value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JExpression value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(final Class<?> value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p(value.getName().replace('$', '.'));
                f.p(".class");
            }
        });
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JType type) {
        JClass clazz = type.boxify();
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(clazz.dotclass());
        this.values.add(annotationValue);
        return this;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public JAnnotationUse annotate(JClass clazz) {
        JAnnotationUse a = new JAnnotationUse(clazz);
        this.values.add(a);
        return a;
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.values);
    }

    public JAnnotationArrayMember param(JAnnotationUse value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void generate(JFormatter f) {
        f.p('{').nl().i();
        boolean first = true;
        for (JAnnotationValue aValue : this.values) {
            if (!first) {
                f.p(',').nl();
            }
            f.g(aValue);
            first = false;
        }
        f.nl().o().p('}');
    }
}

