/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.codemodel;

import com.tangosol.internal.codemodel.JAnonymousClass;
import com.tangosol.internal.codemodel.JClass;
import com.tangosol.internal.codemodel.JDefinedClass;
import com.tangosol.internal.codemodel.JExpr;
import com.tangosol.internal.codemodel.JExpression;
import com.tangosol.internal.codemodel.JExpressionImpl;
import com.tangosol.internal.codemodel.JFormatter;
import com.tangosol.internal.codemodel.JGenerable;
import com.tangosol.internal.codemodel.JMethod;
import com.tangosol.internal.codemodel.JStatement;
import com.tangosol.internal.codemodel.JType;
import java.util.ArrayList;
import java.util.List;

public final class JInvocation
extends JExpressionImpl
implements JStatement {
    private JGenerable object;
    private String name;
    private JMethod method;
    private boolean isConstructor = false;
    private List<JExpression> args = new ArrayList<JExpression>();
    private JType type = null;

    JInvocation(JExpression object, String name) {
        this((JGenerable)object, name);
    }

    JInvocation(JExpression object, JMethod method) {
        this((JGenerable)object, method);
    }

    JInvocation(JClass type, String name) {
        this((JGenerable)type, name);
    }

    JInvocation(JClass type, JMethod method) {
        this((JGenerable)type, method);
    }

    private JInvocation(JGenerable object, String name) {
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("method name contains '.': " + name);
        }
        this.name = name;
    }

    private JInvocation(JGenerable object, JMethod method) {
        this.object = object;
        this.method = method;
    }

    JInvocation(JType c) {
        this.isConstructor = true;
        this.type = c;
    }

    public JInvocation arg(JExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        this.args.add(arg);
        return this;
    }

    public JInvocation arg(String v) {
        return this.arg(JExpr.lit(v));
    }

    public JExpression[] listArgs() {
        return this.args.toArray(new JExpression[this.args.size()]);
    }

    public void generate(JFormatter f) {
        if (this.isConstructor && this.type.isArray()) {
            f.p("new").g(this.type).p('{');
        } else if (this.isConstructor) {
            f.p("new").g(this.type).p('(');
        } else {
            String name = this.name;
            if (name == null) {
                name = this.method.name();
            }
            if (this.object != null) {
                f.g(this.object).p('.').p(name).p('(');
            } else {
                f.id(name).p('(');
            }
        }
        f.g(this.args);
        if (this.isConstructor && this.type.isArray()) {
            f.p('}');
        } else {
            f.p(')');
        }
        if (this.type instanceof JDefinedClass && ((JDefinedClass)this.type).isAnonymous()) {
            ((JAnonymousClass)this.type).declareBody(f);
        }
    }

    public void state(JFormatter f) {
        f.g(this).p(';').nl();
    }
}

