/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.jandex;

import com.tangosol.internal.jandex.AnnotationTarget;
import com.tangosol.internal.jandex.ClassInfo;
import com.tangosol.internal.jandex.FieldInfo;
import com.tangosol.internal.jandex.MethodInfo;
import com.tangosol.internal.jandex.TypeTarget;

public final class MethodParameterInfo
implements AnnotationTarget {
    private final MethodInfo method;
    private final short parameter;

    MethodParameterInfo(MethodInfo method, short parameter) {
        this.method = method;
        this.parameter = parameter;
    }

    public static MethodParameterInfo create(MethodInfo method, short parameter) {
        return new MethodParameterInfo(method, parameter);
    }

    public final MethodInfo method() {
        return this.method;
    }

    public final short position() {
        return this.parameter;
    }

    public final String name() {
        return this.method.parameterName(this.parameter);
    }

    public String toString() {
        return this.method + " #" + this.parameter;
    }

    @Override
    public final ClassInfo asClass() {
        throw new IllegalArgumentException("Not a class");
    }

    @Override
    public final FieldInfo asField() {
        throw new IllegalArgumentException("Not a field");
    }

    @Override
    public final MethodInfo asMethod() {
        throw new IllegalArgumentException("Not a method");
    }

    @Override
    public final MethodParameterInfo asMethodParameter() {
        return this;
    }

    @Override
    public final TypeTarget asType() {
        throw new IllegalArgumentException("Not a type");
    }

    @Override
    public AnnotationTarget.Kind kind() {
        return AnnotationTarget.Kind.METHOD_PARAMETER;
    }
}

