/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.config.expression.ChainedParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.PropertiesParameterResolver;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.net.ScopedUriScopeResolver;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.Coherence;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.util.RegistrationBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class DefaultSessionProvider
implements SessionProvider {
    public static final DefaultSessionProvider INSTANCE = new DefaultSessionProvider();
    public static final int DEFAULT_PRIORITY = 0;
    private final Supplier<CacheFactoryBuilder> f_cacheFactoryBuilder;
    private final List<SessionProvider> f_listProvider;

    protected DefaultSessionProvider() {
        this(null);
    }

    DefaultSessionProvider(Supplier<CacheFactoryBuilder> cacheFactoryBuilder) {
        this.f_cacheFactoryBuilder = cacheFactoryBuilder == null ? CacheFactory::getCacheFactoryBuilder : cacheFactoryBuilder;
        ArrayList<SessionProvider> list = new ArrayList<SessionProvider>();
        ServiceLoader<SessionProvider> loader = ServiceLoader.load(SessionProvider.class);
        for (SessionProvider provider : loader) {
            list.add(provider);
        }
        list.sort(Comparator.reverseOrder());
        this.f_listProvider = list;
    }

    public static SessionProvider getBaseProvider() {
        return RootProvider.INSTANCE;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
        SessionProvider.Context result = null;
        if (configuration instanceof SessionProvider.Provider) {
            result = ((SessionProvider.Provider)((Object)configuration)).getSessionProvider().map(p -> p.createSession(configuration, context)).orElse(context);
        }
        if (result != null && result.isComplete()) {
            return result;
        }
        for (SessionProvider provider : this.f_listProvider) {
            result = provider.createSession(configuration, context);
            if (result == null || !result.isComplete()) continue;
            return result;
        }
        return this.ensureSession(configuration, context);
    }

    @Override
    public void close() {
        for (SessionProvider provider : this.f_listProvider) {
            try {
                provider.close();
            }
            catch (Throwable t) {
                Logger.err(t);
            }
        }
    }

    protected SessionProvider.Context ensureSession(SessionConfiguration configuration, SessionProvider.Context context) {
        String sConfigLocation = configuration.getConfigUri().orElse("$Default$");
        String scopeName = configuration.getScopeName();
        ClassLoader loader = configuration.getClassLoader().orElse(Classes.getContextClassLoader());
        String name = configuration.getName();
        String sConfigUri = ScopedUriScopeResolver.encodeScope(sConfigLocation, scopeName);
        ParameterResolver resolverCfg = configuration.getParameterResolver().orElse(null);
        if (context.getMode() == Coherence.Mode.Client) {
            String sProp = Config.getProperty("coherence.client", "remote");
            Map<String, String> map = Collections.singletonMap("coherence.client", sProp);
            resolverCfg = resolverCfg == null ? new PropertiesParameterResolver(map) : new ChainedParameterResolver(resolverCfg, new PropertiesParameterResolver(map));
        }
        CacheFactoryBuilder cfb = this.f_cacheFactoryBuilder.get();
        ConfigurableCacheFactory factory = cfb.getConfigurableCacheFactory(sConfigUri, loader, resolverCfg);
        Iterable<EventInterceptor<?>> interceptors = context.getInterceptors();
        if (interceptors != null) {
            InterceptorRegistry registry = factory.getInterceptorRegistry();
            for (EventInterceptor<?> interceptor : interceptors) {
                registry.registerEventInterceptor(interceptor, RegistrationBehavior.FAIL);
            }
        }
        ConfigurableCacheFactorySession session = new ConfigurableCacheFactorySession(factory, loader, name);
        session.activate();
        return context.complete(session);
    }

    private static class RootProvider
    extends DefaultSessionProvider {
        static RootProvider INSTANCE = new RootProvider();

        private RootProvider() {
        }

        @Override
        public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
            return this.ensureSession(configuration, context);
        }
    }
}

