/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.net.Service;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import java.util.Objects;
import java.util.Set;

public class SessionNamedTopic<V>
implements NamedTopic<V> {
    private final NamedTopic<V> f_topic;
    private final ClassLoader f_loader;
    private final ConfigurableCacheFactorySession f_session;
    private final ValueTypeAssertion f_typeAssertion;
    private volatile boolean m_fActive;

    public SessionNamedTopic(ConfigurableCacheFactorySession session, NamedTopic<V> topic, ValueTypeAssertion<V> typeAssertion) {
        this(session, topic, session.getConfigurableCacheFactory().getClass().getClassLoader(), typeAssertion);
    }

    public SessionNamedTopic(ConfigurableCacheFactorySession session, NamedTopic<V> topic, ClassLoader loader, ValueTypeAssertion<V> typeAssertion) {
        this.f_topic = Objects.requireNonNull(topic);
        this.f_session = Objects.requireNonNull(session);
        this.f_typeAssertion = typeAssertion;
        this.f_loader = Objects.requireNonNull(loader);
        this.m_fActive = this.f_topic.isActive();
    }

    NamedTopic<V> getInternalNamedTopic() {
        return this.f_topic;
    }

    ValueTypeAssertion<V> getTypeAssertion() {
        return this.f_typeAssertion;
    }

    void onClosing() {
        this.m_fActive = false;
    }

    void onClosed() {
    }

    void onDestroying() {
        this.m_fActive = false;
    }

    void onDestroyed() {
    }

    @Override
    public Subscriber<V> createSubscriber(Subscriber.Option ... options) {
        return this.f_topic.createSubscriber(options);
    }

    @Override
    public void destroySubscriberGroup(String sGroupName) {
        this.f_topic.destroySubscriberGroup(sGroupName);
    }

    @Override
    public Set<String> getSubscriberGroups() {
        return this.f_topic.getSubscriberGroups();
    }

    @Override
    public Publisher<V> createPublisher(Publisher.Option ... options) {
        return this.f_topic.createPublisher(options);
    }

    @Override
    public void release() {
        if (this.m_fActive) {
            this.f_session.onClose(this);
        }
    }

    @Override
    public void destroy() {
        if (this.m_fActive) {
            this.f_session.onDestroy(this);
        }
    }

    @Override
    public String getName() {
        return this.f_topic.getName();
    }

    @Override
    public Service getService() {
        return this.f_topic.getService();
    }

    @Override
    public boolean isActive() {
        return this.m_fActive && this.f_topic.isActive();
    }

    @Override
    public boolean isDestroyed() {
        return this.f_topic.isDestroyed();
    }

    @Override
    public boolean isReleased() {
        return this.f_topic.isReleased();
    }

    ClassLoader getContextClassLoader() {
        return this.f_loader;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SessionNamedTopic) {
            SessionNamedTopic sessionOther = (SessionNamedTopic)obj;
            return Base.equals(this.f_session, sessionOther.f_session) && Base.equals(this.f_topic, sessionOther.f_topic) && this.f_loader.equals(sessionOther.f_loader);
        }
        return false;
    }

    public int hashCode() {
        int hash = HashHelper.hash(this.f_session, 31);
        return HashHelper.hash(this.f_topic, hash) + this.f_loader.hashCode();
    }

    public String toString() {
        return this.f_topic.toString();
    }
}

