/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.net.Coherence;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import java.util.Optional;

public class SystemSessionConfiguration
implements SessionConfiguration {
    public static final int PROVIDER_PRIORITY = 0;
    public static final SystemSessionConfiguration INSTANCE = new SystemSessionConfiguration();

    @Override
    public String getName() {
        return "$SYS";
    }

    @Override
    public String getScopeName() {
        return "$SYS";
    }

    @Override
    public Optional<String> getConfigUri() {
        return Optional.of("coherence-system-config.xml");
    }

    public static class SystemSessionProvider
    implements SessionProvider {
        static final SystemSessionProvider INSTANCE = new SystemSessionProvider();

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
            if ("$SYS".equals(configuration.getName())) {
                if (context.getMode() == Coherence.Mode.ClusterMember) {
                    return context.createSession(INSTANCE);
                }
                return context.complete();
            }
            return context;
        }
    }
}

