/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.metrics;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.service.grid.DefaultProxyServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlProxyServiceHelper;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public abstract class MetricsHttpHelper {
    public static final String PROP_METRICS_ENABLED = "coherence.metrics.http.enabled";
    public static final int DEFAULT_PROMETHEUS_METRICS_PORT = 9612;

    public static URL composeURL(String sHost, int nPort) throws MalformedURLException {
        return MetricsHttpHelper.composeURL(sHost, nPort, "http");
    }

    public static URL composeURL(String sHost, int nPort, String sProtocol) throws MalformedURLException {
        return new URL(sProtocol, sHost, nPort, "/metrics");
    }

    public static ProxyServiceDependencies getDependencies(OperationalContext ctx) {
        URL urlConfig = Base.getContextClassLoader().getResource("metrics-http-config.xml");
        if (urlConfig == null) {
            throw new IllegalStateException("Unable to locate metrics-http-config.xml that should be resolvable from the coherence-metrics module on the class path.");
        }
        XmlDocument xml = XmlHelper.loadXml(urlConfig);
        XmlHelper.replaceSystemProperties(xml, "system-property");
        return LegacyXmlProxyServiceHelper.fromXml(xml, new DefaultProxyServiceDependencies(), ctx, Base.getContextClassLoader());
    }

    public static String getServiceName() {
        return "MetricsHttpProxy";
    }

    public static boolean isHttpCapable() {
        try {
            Base.getContextClassLoader().loadClass("com.tangosol.coherence.metrics.internal.MetricsResourceConfig");
        }
        catch (Throwable t) {
            Logger.finest("One or more libraries are missing for Metrics over HTTP: " + t);
            return false;
        }
        return true;
    }

    public static void ensureMetricsService(Map<Service, String> mapServices) {
        boolean fEnabled = Config.getBoolean(PROP_METRICS_ENABLED, false);
        if (fEnabled) {
            Cluster cluster = CacheFactory.ensureCluster();
            if (cluster.getManagement() == null) {
                Logger.err("Metrics over HTTP is not available due to management not being enabled");
            } else {
                if (MetricsHttpHelper.isHttpCapable()) {
                    ProxyServiceDependencies deps = MetricsHttpHelper.getDependencies((OperationalContext)((Object)cluster));
                    try {
                        ProxyService service = (ProxyService)cluster.ensureService(MetricsHttpHelper.getServiceName(), "Proxy");
                        service.setDependencies(deps);
                        service.start();
                        mapServices.put(service, MetricsHttpHelper.getServiceName());
                        return;
                    }
                    catch (Throwable t) {
                        Throwable tCause;
                        Throwable tOriginal = t instanceof RuntimeException ? Base.getOriginalException((RuntimeException)t) : t;
                        Throwable throwable = tCause = tOriginal.getCause() == null ? tOriginal : tOriginal.getCause();
                        if (tCause instanceof ClassNotFoundException) {
                            Logger.err("Metrics over HTTP is not available most likely due to this member missing the necessary libraries to run the service. Handled exception: " + tCause.getClass().getSimpleName() + ": " + tCause.getLocalizedMessage());
                            return;
                        }
                        HttpAcceptorDependencies depsHttpAcceptor = (HttpAcceptorDependencies)deps.getAcceptorDependencies();
                        Logger.err("failed to start service " + MetricsHttpHelper.getServiceName() + " at address " + depsHttpAcceptor.getLocalAddress() + ":" + depsHttpAcceptor.getLocalPort() + " due to " + tCause.getClass().getSimpleName() + " : " + Base.getDeepMessage(tCause, ":"));
                        return;
                    }
                }
                Logger.err("Metrics over HTTP is not available most likely due to missing the necessary libraries to run the service ");
            }
        }
    }
}

