/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.extend.remote;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.RemoteServiceDependencies;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.io.SerializerFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;

public class DefaultRemoteServiceDependencies
extends DefaultServiceDependencies
implements RemoteServiceDependencies {
    private String m_sNameClusterRemote;
    private String m_sNameServiceRemote;
    private InitiatorDependencies m_initiatorDependencies;

    public DefaultRemoteServiceDependencies() {
        this(null);
    }

    public DefaultRemoteServiceDependencies(RemoteServiceDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_sNameClusterRemote = deps.getRemoteClusterName();
            this.m_sNameServiceRemote = deps.getRemoteServiceName();
            this.m_initiatorDependencies = deps.getInitiatorDependencies();
        }
    }

    @Override
    public String getRemoteClusterName() {
        return this.m_sNameClusterRemote;
    }

    @Injectable(value="cluster-name")
    public void setRemoteClusterName(String sName) {
        this.m_sNameClusterRemote = sName;
    }

    @Override
    public String getRemoteServiceName() {
        return this.m_sNameServiceRemote;
    }

    @Injectable(value="proxy-service-name")
    public void setRemoteServiceName(String sName) {
        this.m_sNameServiceRemote = sName;
    }

    @Override
    public InitiatorDependencies getInitiatorDependencies() {
        return this.m_initiatorDependencies;
    }

    @Injectable(value="initiator-config")
    public void setInitiatorDependencies(InitiatorDependencies deps) {
        this.m_initiatorDependencies = deps;
    }

    @Override
    public DefaultRemoteServiceDependencies validate() {
        Base.checkNotNull(this.getInitiatorDependencies(), "InitiatorDependencies");
        return this;
    }

    @Override
    public long getRequestTimeoutMillis() {
        InitiatorDependencies depsInitiator = this.getInitiatorDependencies();
        return depsInitiator == null ? super.getRequestTimeoutMillis() : depsInitiator.getRequestSendTimeoutMillis();
    }

    @Override
    public SerializerFactory getSerializerFactory() {
        return this.getInitiatorDependencies().getSerializerFactory();
    }

    @Override
    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{RemoteCluster=" + this.getRemoteClusterName() + ", RemoteService=" + this.getRemoteServiceName() + ", InitiatorDependencies=" + this.getInitiatorDependencies() + "}";
    }
}

