/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.LocalAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.builder.WrapperSocketAddressProviderBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.service.peer.acceptor.AbstractAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.NameService;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import java.net.InetAddress;
import java.net.SocketException;

public class DefaultTcpAcceptorDependencies
extends AbstractAcceptorDependencies
implements TcpAcceptorDependencies {
    private volatile ParameterizedBuilder<SocketAddressProvider> m_bldrAddressProviderLocal;
    private TcpAcceptorDependencies.BufferPoolConfig m_bufferPoolConfigIncoming;
    private TcpAcceptorDependencies.BufferPoolConfig m_bufferPoolConfigOutgoing;
    private long m_cbDefaultLimitBytes = 100000000L;
    private int m_cDefaultLimitMessages = 60000;
    private long m_cbDefaultNominalBytes = 2000000L;
    private int m_cDefaultNominalMessages = 2000;
    private long m_cbDefaultSuspectBytes = 10000000L;
    private int m_cDefaultSuspectMessages = 10000;
    private ParameterizedBuilder<Filter> m_bldrFilterAuthorizedHost;
    private int m_cListenBacklog;
    private SocketOptions m_socketOptions;
    private SocketProviderBuilder m_builderSocketProvider;
    private boolean m_fSuspectProtocolEnabled = true;
    private OperationalContext m_ctxOperational;

    public DefaultTcpAcceptorDependencies() {
        this(null);
    }

    public DefaultTcpAcceptorDependencies(TcpAcceptorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_bldrAddressProviderLocal = deps.getLocalAddressProviderBuilder();
            this.m_bldrFilterAuthorizedHost = deps.getAuthorizedHostFilterBuilder();
            this.m_cbDefaultLimitBytes = deps.getDefaultLimitBytes();
            this.m_cDefaultLimitMessages = deps.getDefaultLimitMessages();
            this.m_cbDefaultNominalBytes = deps.getDefaultNominalBytes();
            this.m_cDefaultNominalMessages = deps.getDefaultNominalMessages();
            this.m_cbDefaultSuspectBytes = deps.getDefaultSuspectBytes();
            this.m_cDefaultSuspectMessages = deps.getDefaultSuspectMessages();
            this.m_bufferPoolConfigIncoming = deps.getIncomingBufferPoolConfig();
            this.m_cListenBacklog = deps.getListenBacklog();
            this.m_bufferPoolConfigOutgoing = deps.getOutgoingBufferPoolConfig();
            this.m_socketOptions = deps.getSocketOptions();
            this.m_builderSocketProvider = deps.getSocketProviderBuilder();
            this.m_fSuspectProtocolEnabled = deps.isSuspectProtocolEnabled();
        }
    }

    @Injectable(value="com.tangosol.net.OperationalContext")
    public void setOperationalContext(OperationalContext ctxOperational) {
        this.m_ctxOperational = ctxOperational;
    }

    @Override
    public ParameterizedBuilder<Filter> getAuthorizedHostFilterBuilder() {
        return this.m_bldrFilterAuthorizedHost;
    }

    @Injectable(value="authorized-hosts")
    public void setAuthorizedHostFilterBuilder(ParameterizedBuilder<Filter> builder) {
        this.m_bldrFilterAuthorizedHost = builder;
    }

    @Override
    public long getDefaultLimitBytes() {
        return this.m_cbDefaultLimitBytes;
    }

    @Injectable(value="limit-buffer-size")
    public void setDefaultLimitBytes(long cbSize) {
        this.m_cbDefaultLimitBytes = cbSize;
    }

    @Override
    public int getDefaultLimitMessages() {
        return this.m_cDefaultLimitMessages;
    }

    @Injectable(value="limit-buffer-length")
    public void setDefaultLimitMessages(int cMessages) {
        this.m_cDefaultLimitMessages = cMessages;
    }

    @Override
    public long getDefaultNominalBytes() {
        return this.m_cbDefaultNominalBytes;
    }

    @Injectable(value="nominal-buffer-size")
    public void setDefaultNominalBytes(long cbSize) {
        this.m_cbDefaultNominalBytes = cbSize;
    }

    @Override
    public int getDefaultNominalMessages() {
        return this.m_cDefaultNominalMessages;
    }

    @Injectable(value="nominal-buffer-length")
    public void setDefaultNominalMessages(int cMessages) {
        this.m_cDefaultNominalMessages = cMessages;
    }

    @Override
    public long getDefaultSuspectBytes() {
        return this.m_cbDefaultSuspectBytes;
    }

    @Injectable(value="suspect-buffer-size")
    public void setDefaultSuspectBytes(long cbSize) {
        this.m_cbDefaultSuspectBytes = cbSize;
    }

    @Override
    public int getDefaultSuspectMessages() {
        return this.m_cDefaultSuspectMessages;
    }

    @Injectable(value="suspect-buffer-length")
    public void setDefaultSuspectMessages(int cMessages) {
        this.m_cDefaultSuspectMessages = cMessages;
    }

    @Override
    public TcpAcceptorDependencies.BufferPoolConfig getIncomingBufferPoolConfig() {
        TcpAcceptorDependencies.BufferPoolConfig config = this.m_bufferPoolConfigIncoming;
        if (config == null) {
            this.m_bufferPoolConfigIncoming = config = new PoolConfig();
        }
        return config;
    }

    @Injectable(value="incoming-buffer-pool")
    public void setIncomingBufferPoolConfig(TcpAcceptorDependencies.BufferPoolConfig config) {
        this.m_bufferPoolConfigIncoming = config;
    }

    @Override
    public int getListenBacklog() {
        return this.m_cListenBacklog;
    }

    @Injectable(value="listen-backlog")
    public void setListenBacklog(int cConnections) {
        this.m_cListenBacklog = cConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterizedBuilder<SocketAddressProvider> getLocalAddressProviderBuilder() {
        WrapperSocketAddressProviderBuilder bldrSocketAddressProvider = this.m_bldrAddressProviderLocal;
        if (bldrSocketAddressProvider == null) {
            DefaultTcpAcceptorDependencies defaultTcpAcceptorDependencies = this;
            synchronized (defaultTcpAcceptorDependencies) {
                bldrSocketAddressProvider = this.m_bldrAddressProviderLocal;
                if (bldrSocketAddressProvider == null) {
                    int nPort = this.getDefaultPort();
                    bldrSocketAddressProvider = this.m_bldrAddressProviderLocal = new WrapperSocketAddressProviderBuilder(new LocalAddressProviderBuilder(this.getDefaultHost(), nPort, nPort)).setEphemeral(true);
                }
            }
        }
        return bldrSocketAddressProvider;
    }

    @Injectable(value="address-provider")
    public void setLocalAddressProviderBuilder(AddressProviderBuilder bldr) {
        if (bldr != null) {
            boolean fSubPortEphemeral = false;
            if (bldr instanceof LocalAddressProviderBuilder) {
                AddressProviderBuilder newBldr;
                final LocalAddressProviderBuilder lBldr = (LocalAddressProviderBuilder)bldr;
                fSubPortEphemeral = lBldr.getPortMinOriginal() == -1;
                bldr = newBldr = new AddressProviderBuilder(){
                    private LocalAddressProviderBuilder m_LBldr;
                    {
                        this.m_LBldr = lBldr;
                    }

                    @Override
                    public AddressProvider createAddressProvider(ClassLoader loader) {
                        return this.realize(null, loader, null);
                    }

                    @Override
                    public AddressProvider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
                        int nPort;
                        LocalAddressProviderBuilder lBldr2 = this.m_LBldr;
                        InetAddress addr = lBldr2.resolveAddress();
                        if (addr == null) {
                            lBldr2.setAddress(DefaultTcpAcceptorDependencies.this.getDefaultHost());
                        }
                        if ((nPort = lBldr2.getPortMin()) == -1) {
                            nPort = DefaultTcpAcceptorDependencies.this.getDefaultPort();
                            lBldr2.setPortMin(nPort).setPortMax(nPort);
                        }
                        return this.m_LBldr.realize(resolver, loader, listParameters);
                    }
                };
            }
            this.setLocalSocketAddressProviderBuilder(new WrapperSocketAddressProviderBuilder(bldr).setEphemeral(fSubPortEphemeral));
        }
    }

    public void setLocalSocketAddressProviderBuilder(ParameterizedBuilder<SocketAddressProvider> bldr) {
        this.m_bldrAddressProviderLocal = bldr;
    }

    @Override
    public TcpAcceptorDependencies.BufferPoolConfig getOutgoingBufferPoolConfig() {
        TcpAcceptorDependencies.BufferPoolConfig config = this.m_bufferPoolConfigOutgoing;
        if (config == null) {
            this.m_bufferPoolConfigOutgoing = config = new PoolConfig();
        }
        return config;
    }

    @Injectable(value="outgoing-buffer-pool")
    public void setOutgoingBufferPoolConfig(TcpAcceptorDependencies.BufferPoolConfig config) {
        this.m_bufferPoolConfigOutgoing = config;
    }

    @Override
    public SocketOptions getSocketOptions() {
        SocketOptions options = this.m_socketOptions;
        if (options == null) {
            this.m_socketOptions = options = new SocketOptions();
            try {
                options.setOption(8, Boolean.TRUE);
                options.setOption(1, Boolean.TRUE);
                options.setOption(128, 0);
            }
            catch (SocketException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return options;
    }

    @Injectable
    public void setSocketOptions(SocketOptions options) {
        this.m_socketOptions = options;
    }

    @Override
    public SocketProviderBuilder getSocketProviderBuilder() {
        if (this.m_builderSocketProvider == null) {
            this.m_builderSocketProvider = new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
        }
        return this.m_builderSocketProvider;
    }

    @Injectable(value="socket-provider")
    public void setSocketProviderBuilder(SocketProviderBuilder builder) {
        this.m_builderSocketProvider = builder;
    }

    @Override
    public boolean isSuspectProtocolEnabled() {
        return this.m_fSuspectProtocolEnabled;
    }

    @Injectable(value="suspect-protocol-enabled")
    public void setSuspectProtocolEnabled(boolean fEnabled) {
        this.m_fSuspectProtocolEnabled = fEnabled;
    }

    @Override
    public DefaultTcpAcceptorDependencies validate() {
        super.validate();
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{AuthorizedHostFilterBuilder=" + this.getAuthorizedHostFilterBuilder() + ", DefaultLimitBytes=" + this.getDefaultLimitBytes() + ", DefaultLimitMessages=" + this.getDefaultLimitMessages() + ", DefaultNominalBytes=" + this.getDefaultNominalBytes() + ", DefaultNominalMessages=" + this.getDefaultNominalMessages() + ", DefaultSuspectBytes=" + this.getDefaultSuspectBytes() + ", DefaultSuspectMessages=" + this.getDefaultSuspectMessages() + ", IncomingBufferPoolConfig=" + this.getIncomingBufferPoolConfig() + ", ListenBacklog=" + this.getListenBacklog() + ", LocalAddressProvider=" + this.getLocalAddressProviderBuilder() + ", OutgoingBufferPoolConfig=" + this.getOutgoingBufferPoolConfig() + ", SocketOptions=" + this.getSocketOptions() + ", SocketProviderBuilder=" + this.getSocketProviderBuilder() + ", SuspectProtocolEnabled=" + this.isSuspectProtocolEnabled() + "}";
    }

    protected OperationalContext ensureOperationalContext() {
        OperationalContext ctxOperational = this.m_ctxOperational;
        if (ctxOperational == null) {
            ctxOperational = this.m_ctxOperational = (OperationalContext)((Object)CacheFactory.getCluster());
        }
        return ctxOperational;
    }

    protected InetAddress getDefaultHost() {
        NameService service;
        OperationalContext ctx = this.ensureOperationalContext();
        if (ctx instanceof Cluster && (service = ((Cluster)((Object)ctx)).getResourceRegistry().getResource(NameService.class)) != null) {
            return service.getLocalAddress();
        }
        return ctx.getLocalMember().getAddress();
    }

    protected int getDefaultPort() {
        return this.ensureOperationalContext().getLocalTcpPort();
    }

    public static class PoolConfig
    implements TcpAcceptorDependencies.BufferPoolConfig {
        private int m_cbBufferSize = 2048;
        private int m_nBufferType = 0;
        private int m_cbCapacity;

        @Override
        public int getBufferSize() {
            return this.m_cbBufferSize;
        }

        @Injectable
        public PoolConfig setBufferSize(int cbSize) {
            this.m_cbBufferSize = cbSize;
            return this;
        }

        @Override
        public int getBufferType() {
            return this.m_nBufferType;
        }

        @Injectable
        public PoolConfig setBufferType(int nType) {
            this.m_nBufferType = nType;
            return this;
        }

        @Override
        public int getCapacity() {
            return this.m_cbCapacity;
        }

        @Injectable
        public PoolConfig setCapacity(int cbCapacity) {
            this.m_cbCapacity = cbCapacity;
            return this;
        }

        public String toString() {
            return "BufferPoolConfig{BufferSize=" + this.getBufferSize() + ", BufferType=" + (this.getBufferType() == 0 ? "direct" : "heap") + ", Capacity=" + this.getCapacity() + "}";
        }
    }
}

