/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.config.ParameterMacroExpressionParser;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.OperationalConfigNamespaceHandler;
import com.tangosol.coherence.config.xml.processor.PasswordProviderBuilderProcessor;
import com.tangosol.config.xml.DefaultProcessingContext;
import com.tangosol.config.xml.DocumentProcessor;
import com.tangosol.internal.net.ssl.SSLSocketProviderDefaultDependencies;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class LegacyXmlSSLSocketProviderDependencies
extends SSLSocketProvider.DefaultDependencies {
    protected String m_sDescription = "SSLSocketProvider()";
    protected volatile boolean m_fConfigured;
    protected XmlElement m_xml;
    protected SocketProviderFactory.Dependencies m_DependenciesProviderFactory;
    public static final String XML_NAME = "ssl";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_IDENTITY_ALGORITHM = "SunX509";
    public static final String DEFAULT_TRUST_ALGORITHM = "SunX509";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";

    public LegacyXmlSSLSocketProviderDependencies(XmlElement xml) {
        this(xml, null);
    }

    public LegacyXmlSSLSocketProviderDependencies(XmlElement xml, SocketProviderFactory.Dependencies dependencies) {
        if (xml == null) {
            throw new IllegalArgumentException("Null xml");
        }
        this.m_xml = xml;
        this.m_DependenciesProviderFactory = dependencies == null ? new SocketProviderFactory.DefaultDependencies() : dependencies;
    }

    @Override
    public SocketProvider getDelegateSocketProvider() {
        this.ensureConfigured();
        return super.getDelegateSocketProvider();
    }

    @Override
    public SSLContext getSSLContext() {
        this.ensureConfigured();
        return super.getSSLContext();
    }

    @Override
    public boolean isClientAuthenticationRequired() {
        this.ensureConfigured();
        return super.isClientAuthenticationRequired();
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        this.ensureConfigured();
        return super.getHostnameVerifier();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        this.ensureConfigured();
        return super.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocolVersions() {
        this.ensureConfigured();
        return super.getEnabledProtocolVersions();
    }

    @Override
    public Executor getExecutor() {
        this.ensureConfigured();
        return super.getExecutor();
    }

    @Override
    public Logger getLogger() {
        this.ensureConfigured();
        return super.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureConfigured() {
        if (!this.m_fConfigured) {
            XmlElement xmlElement = this.m_xml;
            synchronized (xmlElement) {
                this.applyConfig(this.m_xml);
                this.m_fConfigured = true;
            }
        }
    }

    protected void applyConfig(XmlElement xml) {
        StringBuffer sbDesc = new StringBuffer();
        try {
            SSLEngine engine;
            XmlValue xmlValue;
            Iterator iter;
            XmlElement xmlStore;
            Provider provider;
            String sProvider;
            XmlElement xmlProvider;
            Object factory;
            String sAlgorithm;
            SSLContext ctx = null;
            KeyManager[] aKeyManager = null;
            TrustManager[] aTrustManager = null;
            String sProtocol = xml.ensureElement("protocol").getString(DEFAULT_SSL_PROTOCOL);
            XmlElement xmlChild = xml.getElement("provider");
            if (xmlChild != null) {
                String sProvider2 = xmlChild.ensureElement("name").getString(null);
                Provider provider2 = this.instantiateProvider(xmlChild);
                if (provider2 == null) {
                    if (sProvider2 != null) {
                        ctx = SSLContext.getInstance(sProtocol, sProvider2);
                    }
                } else {
                    ctx = SSLContext.getInstance(sProtocol, provider2);
                }
            }
            if (ctx == null) {
                ctx = SSLContext.getInstance(sProtocol);
            }
            this.m_ctx = ctx;
            xmlChild = xml.getElement("executor");
            if (xmlChild != null) {
                this.m_executor = XmlHelper.isInstanceConfigEmpty(xmlChild) ? SSLSocketProviderDefaultDependencies.DEFAULT_EXECUTOR : (Executor)XmlHelper.createInstance(xmlChild, null, null);
            }
            if ((xmlChild = xml.getElement("identity-manager")) == null) {
                sbDesc.append("identity=unspecified");
            } else {
                sbDesc.append("identity=");
                sAlgorithm = xmlChild.ensureElement("algorithm").getString("SunX509");
                sbDesc.append(sAlgorithm);
                factory = null;
                xmlProvider = xmlChild.getElement("provider");
                if (xmlProvider != null) {
                    sProvider = xmlProvider.ensureElement("name").getString(null);
                    provider = this.instantiateProvider(xmlProvider);
                    if (provider == null) {
                        if (sProvider != null) {
                            factory = KeyManagerFactory.getInstance(sAlgorithm, sProvider);
                        }
                    } else {
                        factory = KeyManagerFactory.getInstance(sAlgorithm, provider);
                    }
                }
                if (factory == null) {
                    factory = KeyManagerFactory.getInstance(sAlgorithm);
                }
                xmlStore = xmlChild.ensureElement("key-store");
                String sPassword = xmlChild.ensureElement("password").getString(null);
                char[] achPassword = null;
                achPassword = sPassword == null ? this.getPwdFromProvider(xmlChild) : sPassword.toCharArray();
                String sURL = xmlStore.ensureElement("url").getString(null);
                String sStorePassword = xmlStore.ensureElement("password").getString(null);
                char[] achStorePassword = null;
                achStorePassword = sStorePassword == null ? this.getPwdFromProvider(xmlStore) : sStorePassword.toCharArray();
                KeyStore keyStore = this.loadKeyStore(sURL, achStorePassword, xmlStore.ensureElement("type").getString(DEFAULT_KEYSTORE_TYPE));
                if (sURL != null && sURL.length() > 0) {
                    sbDesc.append('/').append(sURL);
                }
                if (sPassword != null) {
                    xmlChild.ensureElement("password").setString(null);
                }
                if (sStorePassword != null) {
                    xmlStore.ensureElement("password").setString(null);
                }
                ((KeyManagerFactory)factory).init(keyStore, achPassword);
                aKeyManager = ((KeyManagerFactory)factory).getKeyManagers();
            }
            xmlChild = xml.getElement("trust-manager");
            if (xmlChild == null || xmlChild.getElementList().isEmpty()) {
                sbDesc.append(", trust=unspecified");
            } else {
                sbDesc.append(", trust=");
                sAlgorithm = xmlChild.ensureElement("algorithm").getString("SunX509");
                sbDesc.append(sAlgorithm);
                factory = null;
                xmlProvider = xmlChild.getElement("provider");
                if (xmlProvider != null) {
                    sProvider = xmlProvider.ensureElement("name").getString(null);
                    provider = this.instantiateProvider(xmlProvider);
                    if (provider == null) {
                        if (sProvider != null) {
                            factory = TrustManagerFactory.getInstance(sAlgorithm, sProvider);
                        }
                    } else {
                        factory = TrustManagerFactory.getInstance(sAlgorithm, provider);
                    }
                }
                if (factory == null) {
                    factory = TrustManagerFactory.getInstance(sAlgorithm);
                }
                xmlStore = xmlChild.ensureElement("key-store");
                String sURL = xmlStore.ensureElement("url").getString(null);
                String sTrustPassword = xmlStore.ensureElement("password").getString(null);
                char[] achTrustPassword = null;
                achTrustPassword = sTrustPassword == null ? this.getPwdFromProvider(xmlStore) : sTrustPassword.toCharArray();
                KeyStore keyStore = this.loadKeyStore(sURL, achTrustPassword, xmlStore.ensureElement("type").getString(DEFAULT_KEYSTORE_TYPE));
                if (sURL != null && sURL.length() > 0) {
                    sbDesc.append('/').append(sURL);
                }
                if (sTrustPassword != null) {
                    xmlStore.ensureElement("password").setString(null);
                }
                ((TrustManagerFactory)factory).init(keyStore);
                aTrustManager = ((TrustManagerFactory)factory).getTrustManagers();
                this.m_fClientAuthRequired = aTrustManager != null;
            }
            xmlChild = xml.getElement("hostname-verifier");
            if (xmlChild != null) {
                this.m_hostnameVerifier = (HostnameVerifier)XmlHelper.createInstance(xmlChild, null, null);
                sbDesc.append(", hostname-verifier=enabled");
            }
            SecureRandom random = new SecureRandom();
            random.nextInt();
            ctx.init(aKeyManager, aTrustManager, random);
            xmlChild = xml.getElement("cipher-suites");
            if (xmlChild != null) {
                ArrayList<Object> listCipher = new ArrayList<Object>();
                iter = xmlChild.getElements("name");
                while (iter.hasNext()) {
                    listCipher.add(((XmlElement)iter.next()).getValue());
                }
                xmlValue = xmlChild.getAttribute("usage");
                if (xmlValue != null && xmlValue.getString().equals("black-list")) {
                    engine = ctx.createSSLEngine();
                    ArrayList<String> listDefaultCiphers = new ArrayList<String>(Arrays.asList(engine.getEnabledCipherSuites()));
                    listDefaultCiphers.removeAll(listCipher);
                    listCipher = listDefaultCiphers;
                }
                this.m_asCipherSuitesEnabled = listCipher.toArray(new String[listCipher.size()]);
            }
            if ((xmlChild = xml.getElement("protocol-versions")) != null) {
                ArrayList<Object> listProtocol = new ArrayList<Object>();
                iter = xmlChild.getElements("name");
                while (iter.hasNext()) {
                    listProtocol.add(((XmlElement)iter.next()).getValue());
                }
                xmlValue = xmlChild.getAttribute("usage");
                if (xmlValue != null && xmlValue.getString().equals("black-list")) {
                    engine = ctx.createSSLEngine();
                    ArrayList<String> listDefaultProtocols = new ArrayList<String>(Arrays.asList(engine.getEnabledProtocols()));
                    listDefaultProtocols.removeAll(listProtocol);
                    listProtocol = listDefaultProtocols;
                }
                this.m_asProtocolVersionsEnabled = listProtocol.toArray(new String[listProtocol.size()]);
            }
            if ((xmlChild = xml.getElement("socket-provider")) == null) {
                this.m_DependenciesProviderFactory.getSocketProviderFactory();
                this.setDelegate(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
            } else {
                this.setDelegate(this.m_DependenciesProviderFactory.getSocketProviderFactory().getSocketProvider(xmlChild));
            }
            String sAuth = aKeyManager == null && aTrustManager == null ? "none" : (aKeyManager == null && aTrustManager != null ? "one-way client" : (aKeyManager != null && aTrustManager == null ? "one-way server" : "two-way"));
            this.m_sDescription = sbDesc.insert(0, "SSLSocketProvider(auth=" + sAuth + ", ").append(')').toString();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid configuration: " + xml, e);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Provider instantiateProvider(XmlElement xml) {
        if (XmlHelper.isInstanceConfigEmpty(xml)) {
            return null;
        }
        return (Provider)XmlHelper.createInstance(xml, null, null);
    }

    protected KeyStore loadKeyStore(String sURL, String sPassword, String sType) throws GeneralSecurityException, IOException {
        return this.loadKeyStore(sURL, sPassword == null || sPassword.length() == 0 ? null : sPassword.toCharArray(), sType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore loadKeyStore(String sURL, char[] achPassword, String sType) throws GeneralSecurityException, IOException {
        if (sURL == null || sURL.length() == 0) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(sType);
        InputStream in = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            in = loader.getResourceAsStream(new URL(sURL).getFile());
            if (in == null) {
                in = new URL(sURL).openStream();
            }
            keyStore.load(in, achPassword);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    protected char[] getPwdFromProvider(XmlElement xmlProvider) {
        XmlElement xmlPwdProvider = xmlProvider.ensureElement("password-provider");
        if (xmlPwdProvider != null) {
            OperationalConfigNamespaceHandler nsHandler = new OperationalConfigNamespaceHandler();
            DocumentProcessor.DefaultDependencies dependencies = new DocumentProcessor.DefaultDependencies(nsHandler).setExpressionParser(new ParameterMacroExpressionParser());
            DefaultProcessingContext ctx = new DefaultProcessingContext(dependencies, null);
            ctx.ensureNamespaceHandler("", nsHandler);
            ParameterizedBuilder bldr = (ParameterizedBuilder)new PasswordProviderBuilderProcessor().process(ctx, xmlPwdProvider);
            return ((PasswordProvider)bldr.realize(null, null, null)).get();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.m_sDescription;
    }
}

