/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.DebouncedFlowControl;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Gate;
import com.tangosol.util.LongArray;
import com.tangosol.util.ThreadGateLite;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BatchingOperationsQueue<F> {
    public static final int TRIGGER_OPEN = 0;
    public static final int TRIGGER_CLOSED = 1;
    public static final int TRIGGER_WAIT = 2;
    private final Consumer<Integer> f_functionBatch;
    private final int f_cbInitialBatch;
    private final Deque<Element> f_queuePending;
    private final Deque<Element> f_queueCurrentBatch;
    private int m_cbCurrentBatch;
    private final Gate f_gate;
    private final AtomicInteger f_lockTrigger = new AtomicInteger(0);
    private final DebouncedFlowControl f_backlog;
    private boolean m_fActive = true;

    public BatchingOperationsQueue(Consumer<Integer> functionBatch, int cbInitialBatch) {
        this(functionBatch, cbInitialBatch, new DebouncedFlowControl(cbInitialBatch, Integer.MAX_VALUE));
    }

    public BatchingOperationsQueue(Consumer<Integer> functionBatch, int cbInitialBatch, DebouncedFlowControl backlog) {
        this.f_functionBatch = functionBatch;
        this.f_cbInitialBatch = cbInitialBatch;
        this.f_queuePending = new ConcurrentLinkedDeque<Element>();
        this.f_queueCurrentBatch = new ConcurrentLinkedDeque<Element>();
        this.f_gate = new ThreadGateLite();
        this.f_backlog = backlog;
        this.resetTrigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<F> add(Binary value) {
        Element element = this.createElement(value);
        Gate gate = this.getGate();
        gate.enter(-1L);
        try {
            this.assertActive();
            this.getPending().add(element);
        }
        finally {
            gate.exit();
        }
        this.triggerOperations(this.f_cbInitialBatch);
        this.f_backlog.adjustBacklog(value.length());
        return element.getFuture();
    }

    public void close() {
        Gate gate = this.getGate();
        gate.close(-1L);
        try {
            this.m_fActive = false;
        }
        finally {
            gate.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> flush() {
        Gate gate = this.getGate();
        gate.close(-1L);
        try {
            Deque<Element> queueCurrent = this.getCurrentBatch();
            Deque<Element> queuePending = this.getPending();
            CompletableFuture[] aFutures = (CompletableFuture[])Stream.concat(queueCurrent.stream(), queuePending.stream()).map(Element::getFuture).filter(future -> !future.isDone()).toArray(CompletableFuture[]::new);
            CompletionStage completionStage = CompletableFuture.allOf(aFutures).handle((_void, throwable) -> null);
            return completionStage;
        }
        finally {
            gate.open();
        }
    }

    public List<Binary> getCurrentBatchValues() {
        return this.getCurrentBatch().stream().filter(((Predicate<Element>)Element::isDone).negate()).map(Element::getValue).collect(Collectors.toList());
    }

    public boolean isBatchComplete() {
        return this.getCurrentBatchValues().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(Throwable throwable, OnErrorAction action) {
        Gate gate = this.getGate();
        gate.close(-1L);
        try {
            Deque<Element> queueCurrent = this.getCurrentBatch();
            Deque<Element> queuePending = this.getPending();
            if (action == null) {
                action = OnErrorAction.CompleteWithException;
            }
            if (throwable != null) {
                Logger.fine("Caught asynchronous error " + throwable.getClass().getName() + " - action is " + (Object)((Object)action));
            }
            switch (action) {
                case Retry: {
                    while (true) {
                        if (queueCurrent.isEmpty()) {
                            this.resetTrigger();
                            this.triggerOperations(this.f_cbInitialBatch);
                            return;
                        }
                        Element element2 = queueCurrent.pollLast();
                        int cb = element2.getValue().length();
                        this.m_cbCurrentBatch -= cb;
                        if (element2.isDone()) continue;
                        this.f_backlog.adjustBacklog(cb);
                        queuePending.offerFirst(element2);
                    }
                }
                case Complete: {
                    Stream.concat(queueCurrent.stream(), queuePending.stream()).filter(((Predicate<Element>)Element::isDone).negate()).forEach(Element::complete);
                    this.close();
                    return;
                }
                case CompleteWithException: {
                    Stream.concat(queueCurrent.stream(), queuePending.stream()).filter(((Predicate<Element>)Element::isDone).negate()).forEach(element -> element.completeExceptionally(throwable));
                    this.close();
                    return;
                }
                case Cancel: {
                    Stream.concat(queueCurrent.stream(), queuePending.stream()).filter(((Predicate<Element>)Element::isDone).negate()).forEach(Element::cancel);
                    this.close();
                    return;
                }
            }
            return;
        }
        finally {
            gate.open();
        }
    }

    public boolean isActive() {
        return this.m_fActive;
    }

    protected Element createElement(Binary value) {
        return new Element(value, new CompletableFuture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillCurrentBatch(int cbMaxElements) {
        if (this.m_cbCurrentBatch >= cbMaxElements) {
            return true;
        }
        Gate gate = this.getGate();
        gate.close(-1L);
        try {
            boolean bl;
            Deque<Element> queueCurrent = this.getCurrentBatch();
            Deque<Element> queuePending = this.getPending();
            Element element = (Element)queuePending.poll();
            while (element != null) {
                this.f_backlog.adjustBacklog(-element.getValue().length());
                if (!element.isDone()) {
                    queueCurrent.add(element);
                    int cbBatch = this.m_cbCurrentBatch += element.getValue().length();
                    if (cbBatch >= cbMaxElements) break;
                }
                element = (Element)queuePending.poll();
            }
            if (queueCurrent.isEmpty()) {
                this.resetTrigger();
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            gate.open();
        }
    }

    protected void resetTrigger() {
        this.getTrigger().set(0);
    }

    protected void pause() {
        this.getTrigger().set(2);
    }

    public boolean resume() {
        return this.getTrigger().compareAndSet(2, 1);
    }

    protected void triggerOperations(int cBatchSize) {
        AtomicInteger trigger = this.getTrigger();
        if (trigger.get() == 0 && trigger.compareAndSet(0, 1)) {
            this.f_functionBatch.accept(cBatchSize);
        }
    }

    public void completeElements(int cComplete, LongArray<Throwable> aErrors) {
        Deque<Element> queueCurrent = this.getCurrentBatch();
        for (int i = 0; i < cComplete; ++i) {
            Throwable error;
            Element element = (Element)queueCurrent.poll();
            this.m_cbCurrentBatch -= element.getValue().length();
            if (element.isDone()) continue;
            Throwable throwable = error = aErrors == null ? null : aErrors.get(i);
            if (error == null) {
                element.complete();
                continue;
            }
            element.completeExceptionally(error);
        }
    }

    protected Gate getGate() {
        return this.f_gate;
    }

    protected Deque<Element> getCurrentBatch() {
        return this.f_queueCurrentBatch;
    }

    protected Deque<Element> getPending() {
        return this.f_queuePending;
    }

    protected AtomicInteger getTrigger() {
        return this.f_lockTrigger;
    }

    protected void assertActive() {
        Base.azzert(this.isActive(), "This batching queue is no longer active");
    }

    public static enum OnErrorAction {
        Retry,
        Complete,
        CompleteWithException,
        Cancel;

    }

    public class Element {
        private final CompletableFuture<F> f_future;
        private final Binary f_binValue;

        public Element(Binary binValue, CompletableFuture<F> future) {
            this.f_binValue = binValue;
            this.f_future = future;
        }

        public Binary getValue() {
            return this.f_binValue;
        }

        public CompletableFuture<F> getFuture() {
            return this.f_future;
        }

        public boolean isDone() {
            return this.f_future.isDone();
        }

        public void complete() {
            this.f_future.complete(null);
        }

        public void completeExceptionally(Throwable throwable) {
            this.f_future.completeExceptionally(throwable);
        }

        public void cancel() {
            this.f_future.cancel(true);
        }
    }
}

