/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.DebouncedFlowControl;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.topic.impl.paged.Configuration;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.agent.DestroySubscriptionProcessor;
import com.tangosol.internal.net.topic.impl.paged.agent.EnsureSubscriptionProcessor;
import com.tangosol.internal.net.topic.impl.paged.agent.HeadAdvancer;
import com.tangosol.internal.net.topic.impl.paged.agent.PollProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.NotificationKey;
import com.tangosol.internal.net.topic.impl.paged.model.Page;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.internal.util.Primes;
import com.tangosol.io.Serializer;
import com.tangosol.net.FlowControl;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.CircularArrayList;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.HashHelper;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.filter.InKeySetFilter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PagedTopicSubscriber<V>
implements Subscriber<V>,
AutoCloseable,
MapListenerSupport.SynchronousListener<NotificationKey, int[]> {
    protected static final int LOCK_OPEN = 0;
    protected static final int LOCK_POLL = 1;
    protected static final int LOCK_WAIT = 2;
    protected static final int LOCK_CLOSED = 3;
    protected static final int COLLISION_BACKOFF_COUNT = Integer.parseInt(Config.getProperty("coherence.pagedTopic.collisionBackoff", "100"));
    protected final PagedTopicCaches f_caches;
    protected final Serializer f_serializer;
    protected final SubscriberGroupId f_subscriberGroupId;
    protected final int f_nNotificationId;
    protected final boolean f_fCompleteOnEmpty;
    protected volatile boolean m_fClosed;
    protected Collection<Binary> m_listValuesPrefetched;
    protected final Queue<CompletableFuture<Subscriber.Element<V>>> f_queueReceiveOrders = new ConcurrentLinkedQueue<CompletableFuture<Subscriber.Element<V>>>();
    protected final DebouncedFlowControl f_backlog;
    protected final AtomicInteger f_lockRemoveSubmit = new AtomicInteger();
    protected final Channel[] f_aChannel;
    protected int m_nChannel;
    protected final int f_nChannelStep;
    protected long m_cPolls;
    protected long m_cPollsLast;
    protected long m_cValues;
    protected long m_cValuesLast;
    protected long m_cWait;
    protected long m_cWaitsLast;
    protected long m_cMisses;
    protected long m_cMissesLast;
    protected long m_cMissCollisions;
    protected long m_cMissCollisionsLast;
    protected long m_cNotify;
    protected long m_cNotifyLast;
    protected int m_cHitsSinceLastCollision;
    protected final List<Channel> f_listChannelsContended = new CircularArrayList();
    protected final BitSet f_setPolledChannels;
    protected final BitSet f_setHitChannels;
    protected NamedCacheDeactivationListener m_listenerDeactivation;
    protected GroupDeactivationListener m_listenerGroupDeactivation;
    private final List<Runnable> f_listOnCloseActions = new ArrayList<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> PagedTopicSubscriber(PagedTopicCaches pagedTopicCaches, Subscriber.Option<? super T, V> ... options) {
        Options<Subscriber.Option<Class<Subscriber.CompleteOnEmpty>, V>> optionsMap = Options.from(Subscriber.Option.class, options);
        Subscriber.Name nameOption = optionsMap.get(Subscriber.Name.class, null);
        String sName = nameOption == null ? null : nameOption.getName();
        this.m_listenerDeactivation = new DeactivationListener();
        this.m_listenerGroupDeactivation = new GroupDeactivationListener();
        this.f_caches = Objects.requireNonNull(pagedTopicCaches, "The TopicCaches parameter cannot be null");
        this.f_serializer = this.f_caches.getSerializer();
        this.f_subscriberGroupId = sName == null ? SubscriberGroupId.anonymous() : SubscriberGroupId.withName(sName);
        this.registerDeactivationListener();
        this.f_fCompleteOnEmpty = optionsMap.contains((Subscriber.Option<Class<Subscriber.CompleteOnEmpty>, V>)((Object)Subscriber.CompleteOnEmpty.class));
        this.f_nNotificationId = this.f_caches.newNotifierId();
        Subscriber.Filtered filtered = optionsMap.get(Subscriber.Filtered.class);
        Filter filter = filtered == null ? null : filtered.getFilter();
        Subscriber.Convert convert = optionsMap.get(Subscriber.Convert.class);
        Function function = convert == null ? null : convert.getFunction();
        long cBacklog = this.f_caches.getCacheService().getCluster().getDependencies().getPublisherCloggedCount();
        this.f_backlog = new DebouncedFlowControl(cBacklog * 2L / 3L, cBacklog);
        try {
            int nChannel;
            int cParts = this.f_caches.getPartitionCount();
            int cChannel = this.f_caches.getChannelCount();
            this.f_setPolledChannels = new BitSet(cChannel);
            this.f_setHitChannels = new BitSet(cChannel);
            ArrayList<Subscription.Key> listSubParts = new ArrayList<Subscription.Key>(cParts);
            for (int i = 0; i < cParts; ++i) {
                listSubParts.add(new Subscription.Key(i, 0, this.f_subscriberGroupId));
            }
            Collection<long[]> colPages = sName == null ? null : InvocableMapHelper.invokeAllAsync(this.f_caches.Subscriptions, listSubParts, key -> pagedTopicCaches.getUnitOfOrder(key.getPartitionId()), new EnsureSubscriptionProcessor(0, null, filter, function), new BiConsumer[0]).get().values();
            long lPageBase = pagedTopicCaches.getBasePage();
            long[] alHead = new long[cChannel];
            if (colPages == null || colPages.contains(null)) {
                if (sName != null) {
                    this.f_caches.Subscriptions.lock(this.f_subscriberGroupId, -1L);
                }
                try {
                    colPages = InvocableMapHelper.invokeAllAsync(this.f_caches.Subscriptions, listSubParts, key -> pagedTopicCaches.getUnitOfOrder(key.getPartitionId()), new EnsureSubscriptionProcessor(1, null, filter, function), new BiConsumer[0]).get().values();
                    Configuration configuration = this.f_caches.getConfiguration();
                    for (nChannel = 0; nChannel < cChannel; ++nChannel) {
                        int finChan = nChannel;
                        alHead[nChannel] = configuration.isRetainConsumed() ? colPages.stream().mapToLong(alPage -> Math.max(alPage[finChan], lPageBase)).min().getAsLong() : colPages.stream().mapToLong(alPage -> Math.max(alPage[finChan], lPageBase)).max().getAsLong();
                    }
                    InvocableMapHelper.invokeAllAsync(this.f_caches.Subscriptions, listSubParts, key -> pagedTopicCaches.getUnitOfOrder(key.getPartitionId()), new EnsureSubscriptionProcessor(2, alHead, filter, function), new BiConsumer[0]).join();
                }
                finally {
                    if (sName != null) {
                        this.f_caches.Subscriptions.unlock(this.f_subscriberGroupId);
                    }
                }
            } else {
                for (int nChannel2 = 0; nChannel2 < cChannel; ++nChannel2) {
                    int finChan = nChannel2;
                    alHead[nChannel2] = colPages.stream().mapToLong(alResult -> alResult[finChan]).min().orElse(-1L);
                }
            }
            this.f_aChannel = new Channel[cChannel];
            Channel[] aChannel = this.f_aChannel;
            for (nChannel = 0; nChannel < cChannel; ++nChannel) {
                Channel channel = aChannel[nChannel] = new Channel();
                channel.lHead = alHead[nChannel];
                channel.nNext = -1;
                channel.fEmpty = false;
                int nPart = Math.abs(HashHelper.hash(this.f_subscriberGroupId.hashCode(), nChannel) % cParts);
                channel.subscriberPartitionSync = new Subscription.Key(nPart, nChannel, this.f_subscriberGroupId);
            }
            this.f_nChannelStep = Primes.random(cChannel);
            this.m_nChannel = Base.mod(this.f_nChannelStep, cChannel);
            this.f_caches.Notifications.addMapListener((MapListener<NotificationKey, int[]>)this, new InKeySetFilter(null, this.f_caches.getPartitionNotifierSet(this.f_nNotificationId)), false);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Subscriber.Element<V>> receive() {
        CompletableFuture<Subscriber.Element<V>> future = new CompletableFuture<Subscriber.Element<V>>();
        this.f_queueReceiveOrders.add(future);
        if (this.m_fClosed) {
            future.cancel(true);
            this.f_queueReceiveOrders.remove(future);
            this.ensureActive();
        } else {
            this.f_backlog.incrementBacklog();
            this.scheduleReceives();
        }
        return future;
    }

    @Override
    public FlowControl getFlowControl() {
        return this.f_backlog;
    }

    @Override
    public void entryInserted(MapEvent<NotificationKey, int[]> evt) {
    }

    @Override
    public void entryUpdated(MapEvent<NotificationKey, int[]> evt) {
    }

    @Override
    public void entryDeleted(MapEvent<NotificationKey, int[]> evt) {
        ++this.m_cNotify;
        for (int nChannel : evt.getOldValue()) {
            this.f_aChannel[nChannel].fEmpty = false;
        }
        if (this.f_lockRemoveSubmit.compareAndSet(2, 0)) {
            this.switchChannel();
            this.scheduleReceives();
        }
    }

    @Override
    public void onClose(Runnable action) {
        this.f_listOnCloseActions.add(action);
    }

    @Override
    public boolean isActive() {
        return !this.m_fClosed;
    }

    @Override
    public void close() {
        this.closeInternal(false);
    }

    public String toString() {
        if (this.m_fClosed) {
            return this.getClass().getSimpleName() + "(inactive)";
        }
        long cPollsNow = this.m_cPolls;
        long cValuesNow = this.m_cValues;
        long cMissesNow = this.m_cMisses;
        long cCollNow = this.m_cMissCollisions;
        long cWaitNow = this.m_cWait;
        long cNotifyNow = this.m_cNotify;
        long cPoll = cPollsNow - this.m_cPollsLast;
        long cValues = cValuesNow - this.m_cValuesLast;
        long cMisses = cMissesNow - this.m_cMissesLast;
        long cColl = cCollNow - this.m_cMissCollisionsLast;
        long cWait = cWaitNow - this.m_cWaitsLast;
        long cNotify = cNotifyNow - this.m_cNotifyLast;
        this.m_cPollsLast = cPollsNow;
        this.m_cValuesLast = cValuesNow;
        this.m_cMissesLast = cMissesNow;
        this.m_cMissCollisionsLast = cCollNow;
        this.m_cWaitsLast = cWaitNow;
        this.m_cNotifyLast = cNotifyNow;
        int cChannelsPolled = this.f_setPolledChannels.cardinality();
        int cChannelsHit = this.f_setHitChannels.cardinality();
        String sChannlesHit = this.f_setHitChannels.toString();
        this.f_setPolledChannels.clear();
        this.f_setHitChannels.clear();
        return this.getClass().getSimpleName() + "(topic=" + this.f_caches.getTopicName() + ", group=" + this.f_subscriberGroupId + ", closed=" + this.m_fClosed + ", backlog=" + this.f_backlog + ", channels=" + sChannlesHit + cChannelsHit + "/" + cChannelsPolled + ", batchSize=" + cValues / Math.max(1L, cPoll - cMisses) + ", hitRate=" + (cPoll - cMisses) * 100L / Math.max(1L, cPoll) + "%, colRate=" + cColl * 100L / Math.max(1L, cPoll) + "%, waitNotifyRate=" + cWait * 100L / Math.max(1L, cPoll) + "/" + cNotify * 100L / Math.max(1L, cPoll) + "%" + ')';
    }

    private void ensureActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("The subscriber is not active");
        }
    }

    protected void scheduleHeadIncrement(Channel channel, long lHeadAssumed) {
        if (!this.m_fClosed) {
            InvocableMapHelper.invokeAsync(this.f_caches.Subscriptions, channel.subscriberPartitionSync, this.f_caches.getUnitOfOrder(channel.subscriberPartitionSync.getPartitionId()), new HeadAdvancer(lHeadAssumed + 1L), (lPriorHeadRemote, e2) -> {
                if (lPriorHeadRemote < lHeadAssumed + 1L) {
                    channel.fContended = false;
                } else {
                    if (lHeadAssumed != -1L) {
                        if (!channel.fContended) {
                            channel.fContended = true;
                            this.f_listChannelsContended.add(channel);
                        }
                        this.m_cHitsSinceLastCollision = 0;
                    }
                    if (lPriorHeadRemote > channel.lHead) {
                        channel.lHead = lPriorHeadRemote;
                        channel.nNext = -1;
                    }
                }
            });
        }
    }

    protected void scheduleReceives() {
        long cOrders = this.f_backlog.getBacklog();
        while (cOrders > 0L && !this.m_fClosed && this.f_lockRemoveSubmit.get() == 0 && this.f_lockRemoveSubmit.compareAndSet(0, 1)) {
            Collection<Binary> colPrefetched = this.m_listValuesPrefetched;
            if (colPrefetched != null) {
                Iterator<Binary> iter = colPrefetched.iterator();
                while (iter.hasNext() && this.consumeValue(iter.next())) {
                    iter.remove();
                }
                if (colPrefetched.isEmpty()) {
                    this.m_listValuesPrefetched = null;
                }
            }
            if ((cOrders = this.f_backlog.getBacklog()) == 0L) {
                this.f_lockRemoveSubmit.set(0);
                continue;
            }
            int nChannel = this.m_nChannel;
            Channel channel = this.f_aChannel[nChannel];
            long lHead = channel.lHead;
            int nPart = ((PartitionedService)((Object)this.f_caches.Subscriptions.getCacheService())).getKeyPartitioningStrategy().getKeyPartition(new Page.Key(nChannel, lHead));
            InvocableMapHelper.invokeAsync(this.f_caches.Subscriptions, new Subscription.Key(nPart, nChannel, this.f_subscriberGroupId), this.f_caches.getUnitOfOrder(nPart), new PollProcessor(lHead, (int)cOrders, this.f_nNotificationId), (result, e) -> this.onReceiveResult(channel, lHead, (PollProcessor.Result)result, (Throwable)e));
        }
    }

    protected boolean consumeValue(Binary binValue) {
        CompletableFuture<Subscriber.Element<V>> futureNext;
        while ((futureNext = this.f_queueReceiveOrders.poll()) != null) {
            this.f_backlog.decrementBacklog();
            if (!futureNext.complete(new RemovedElement(binValue))) continue;
            return true;
        }
        return false;
    }

    protected int nextChannel(int nChannel) {
        boolean fContention;
        int cChannels = this.f_aChannel.length;
        int nChannelStart = nChannel;
        boolean bl = fContention = !this.f_listChannelsContended.isEmpty();
        while (fContention) {
            Channel chan = this.f_listChannelsContended.get(0);
            if (!chan.fEmpty && chan.fContended) break;
            this.f_listChannelsContended.remove(0);
            chan.fContended = false;
            fContention = !this.f_listChannelsContended.isEmpty();
        }
        Channel chanContended = this.m_cHitsSinceLastCollision > COLLISION_BACKOFF_COUNT && fContention ? this.f_listChannelsContended.get(0) : null;
        do {
            nChannel = (int)Base.mod((long)nChannel + (long)this.f_nChannelStep, (long)cChannels);
            Channel channel = this.f_aChannel[nChannel];
            if (channel.fEmpty || channel.fContended && channel != chanContended) continue;
            return nChannel;
        } while (nChannel != nChannelStart);
        return fContention ? this.f_listChannelsContended.get((int)0).subscriberPartitionSync.getChannelId() : nChannelStart;
    }

    protected boolean switchChannel() {
        int nChannelNext;
        int nChannelStart = this.m_nChannel;
        int nChannel = this.m_nChannel = this.nextChannel(nChannelStart);
        Channel channel = this.f_aChannel[nChannel];
        if (channel.fEmpty) {
            return false;
        }
        if (channel.fContended) {
            channel.fContended = false;
            this.f_listChannelsContended.remove(0);
        }
        if ((nChannelNext = this.nextChannel(nChannel)) != nChannel && nChannelNext != nChannelStart) {
            Channel channelNext = this.f_aChannel[nChannelNext];
            if (channelNext.fContended) {
                this.scheduleHeadIncrement(channelNext, -1L);
            }
        }
        return true;
    }

    protected void onReceiveResult(Channel channel, long lPageId, PollProcessor.Result result, Throwable e) {
        if (e == null) {
            int nChannel = channel.subscriberPartitionSync.getChannelId();
            List<Binary> listValues = result.getElements();
            int cReceived = listValues.size();
            int cRemaining = result.getRemainingElementCount();
            int nNext = result.getNextIndex();
            this.f_setPolledChannels.set(nChannel);
            ++this.m_cPolls;
            if (cReceived == 0) {
                ++this.m_cMisses;
                if (channel.nNext != nNext && channel.nNext != -1) {
                    ++this.m_cMissCollisions;
                    this.m_cHitsSinceLastCollision = 0;
                }
            } else {
                this.f_setHitChannels.set(nChannel);
                ++this.m_cHitsSinceLastCollision;
                this.m_cValues += (long)cReceived;
                Iterator<Binary> iter = listValues.iterator();
                while (iter.hasNext() && this.consumeValue(iter.next())) {
                    iter.remove();
                }
                if (!listValues.isEmpty()) {
                    this.m_listValuesPrefetched = listValues;
                }
            }
            channel.nNext = nNext;
            if (cRemaining == -1) {
                if (lPageId >= channel.lHead && lPageId != -1L) {
                    channel.lHead = lPageId + 1L;
                    channel.nNext = 0;
                }
                this.scheduleHeadIncrement(channel, lPageId);
                this.switchChannel();
            } else if (cRemaining == 0) {
                channel.fEmpty = true;
                if (!this.switchChannel()) {
                    if (this.f_fCompleteOnEmpty) {
                        CompletableFuture<Subscriber.Element<V>> next;
                        while ((next = this.f_queueReceiveOrders.poll()) != null) {
                            this.f_backlog.decrementBacklog();
                            next.complete(null);
                        }
                    } else {
                        ++this.m_cWait;
                        this.f_lockRemoveSubmit.set(2);
                    }
                }
            } else if (cRemaining == -2) {
                this.closeInternal(true);
            }
            if (this.m_fClosed) {
                this.f_queueReceiveOrders.forEach(future -> future.cancel(true));
                this.f_lockRemoveSubmit.set(3);
            } else if (this.f_lockRemoveSubmit.compareAndSet(1, 0)) {
                this.scheduleReceives();
            }
        } else {
            CompletableFuture<Subscriber.Element<V>> next;
            while ((next = this.f_queueReceiveOrders.poll()) != null) {
                this.f_backlog.decrementBacklog();
                next.completeExceptionally(e);
            }
            this.f_lockRemoveSubmit.set(0);
            this.scheduleReceives();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroy(PagedTopicCaches pagedTopicCaches, SubscriberGroupId subscriberGroupId) {
        boolean fNamed;
        int cParts = ((PartitionedService)((Object)pagedTopicCaches.Subscriptions.getCacheService())).getPartitionCount();
        ArrayList<Subscription.Key> listSubParts = new ArrayList<Subscription.Key>(cParts);
        for (int i = 0; i < cParts; ++i) {
            listSubParts.add(new Subscription.Key(i, 0, subscriberGroupId));
        }
        boolean bl = fNamed = subscriberGroupId.getMemberTimestamp() == 0L;
        if (fNamed) {
            pagedTopicCaches.Subscriptions.lock(subscriberGroupId, -1L);
        }
        try {
            InvocableMapHelper.invokeAllAsync(pagedTopicCaches.Subscriptions, listSubParts, key -> pagedTopicCaches.getUnitOfOrder(key.getPartitionId()), DestroySubscriptionProcessor.INSTANCE, new BiConsumer[0]).join();
        }
        finally {
            if (fNamed) {
                pagedTopicCaches.Subscriptions.unlock(subscriberGroupId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean fDestroyed) {
        PagedTopicSubscriber pagedTopicSubscriber = this;
        synchronized (pagedTopicSubscriber) {
            if (!this.m_fClosed) {
                this.m_fClosed = true;
                try {
                    if (!fDestroyed) {
                        this.unregisterDeactivationListener();
                        this.f_caches.Notifications.removeMapListener((MapListener<NotificationKey, int[]>)this, new InKeySetFilter(null, this.f_caches.getPartitionNotifierSet(this.f_nNotificationId)));
                    }
                    if (fDestroyed || this.f_lockRemoveSubmit.compareAndSet(0, 3) || this.f_lockRemoveSubmit.compareAndSet(2, 3)) {
                        this.f_queueReceiveOrders.forEach(future -> future.cancel(true));
                    } else {
                        ((CompletableFuture)CompletableFuture.allOf(this.f_queueReceiveOrders.toArray(new CompletableFuture[0])).handle((v, t) -> null)).join();
                    }
                    if (!fDestroyed && this.f_subscriberGroupId.getMemberTimestamp() != 0L) {
                        PagedTopicSubscriber.destroy(this.f_caches, this.f_subscriberGroupId);
                    }
                }
                finally {
                    this.f_listOnCloseActions.forEach(action -> {
                        try {
                            action.run();
                        }
                        catch (Throwable t) {
                            Logger.fine(this.getClass().getName() + ".close(): handled onClose exception: " + t.getClass().getCanonicalName() + ": " + t.getMessage());
                        }
                    });
                }
            }
        }
    }

    protected void registerDeactivationListener() {
        try {
            NamedCacheDeactivationListener listener;
            GroupDeactivationListener listenerGroup = this.m_listenerGroupDeactivation;
            if (listenerGroup != null) {
                this.f_caches.Subscriptions.addMapListener((MapListener<Subscription.Key, Subscription>)listenerGroup, new Subscription.Key(0, 0, this.f_subscriberGroupId), true);
            }
            if ((listener = this.m_listenerDeactivation) != null) {
                this.f_caches.Subscriptions.addMapListener(listener);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void unregisterDeactivationListener() {
        try {
            NamedCacheDeactivationListener listener;
            GroupDeactivationListener listenerGroup = this.m_listenerGroupDeactivation;
            if (listenerGroup != null) {
                this.f_caches.Subscriptions.removeMapListener((MapListener<Subscription.Key, Subscription>)listenerGroup, new Subscription.Key(0, 0, this.f_subscriberGroupId));
            }
            if ((listener = this.m_listenerDeactivation) != null) {
                this.f_caches.Subscriptions.removeMapListener(listener);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected class GroupDeactivationListener
    extends AbstractMapListener {
        protected GroupDeactivationListener() {
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            Logger.fine("Detected removal of subscriber group " + PagedTopicSubscriber.this.f_subscriberGroupId.getGroupName() + ", closing subscriber " + PagedTopicSubscriber.this);
            PagedTopicSubscriber.this.closeInternal(true);
        }
    }

    protected class DeactivationListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        protected DeactivationListener() {
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            Logger.fine("Detected destroy of topic " + PagedTopicSubscriber.this.f_caches.getTopicName() + ", closing subscriber " + PagedTopicSubscriber.this);
            PagedTopicSubscriber.this.closeInternal(true);
        }
    }

    protected static class Channel {
        volatile long lHead;
        int nNext = -1;
        boolean fEmpty;
        Subscription.Key subscriberPartitionSync;
        boolean fContended;

        protected Channel() {
        }

        public String toString() {
            return "Channel=" + this.subscriberPartitionSync.getChannelId() + ", empty=" + this.fEmpty + ", head=" + this.lHead + ", next=" + this.nNext + ", contended=" + this.fContended;
        }
    }

    private class RemovedElement
    implements Subscriber.Element<V> {
        private Binary m_binValue;
        private volatile V m_value;

        RemovedElement(Binary binValue) {
            this.m_binValue = binValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getValue() {
            Binary binValue = this.m_binValue;
            Object value = this.m_value;
            if (binValue != null) {
                RemovedElement removedElement = this;
                synchronized (removedElement) {
                    binValue = this.m_binValue;
                    if (binValue == null) {
                        value = this.m_value;
                    } else {
                        this.m_value = value = ExternalizableHelper.fromBinary(binValue, PagedTopicSubscriber.this.f_serializer);
                        this.m_binValue = null;
                    }
                }
            }
            return value;
        }
    }
}

