/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PollProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, Result>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 1;
    protected long m_lPage;
    protected int m_cElements;
    protected int m_nNotifyPostEmpty;

    public PollProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public PollProcessor(long lPage, int cElements, int nNotifyPostEmpty) {
        super(PagedTopicPartition::ensureTopic);
        this.m_lPage = lPage;
        this.m_cElements = cElements;
        this.m_nNotifyPostEmpty = nNotifyPostEmpty;
    }

    @Override
    public Result process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        return this.ensureTopic(entry).pollFromPageHead((BinaryEntry)entry, this.m_lPage, this.m_cElements, this.m_nNotifyPostEmpty);
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lPage = in.readLong(0);
        this.m_cElements = in.readInt(1);
        this.m_nNotifyPostEmpty = in.readInt(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lPage);
        out.writeInt(1, this.m_cElements);
        out.writeInt(2, this.m_nNotifyPostEmpty);
    }

    public static class Result
    extends AbstractEvolvable
    implements EvolvablePortableObject {
        public static final int EXHAUSTED = -1;
        public static final int DATA_VERSION = 1;
        public static final int UNKNOWN_SUBSCRIBER = -2;
        private int m_cElementsRemaining;
        private int m_nNext;
        private List<Binary> m_listElements;

        public Result() {
        }

        public Result(int cElementsRemaining, int nNext, List<Binary> listElements) {
            this.m_cElementsRemaining = cElementsRemaining;
            this.m_nNext = nNext;
            this.m_listElements = listElements == null ? Collections.emptyList() : listElements;
        }

        public int getRemainingElementCount() {
            return this.m_cElementsRemaining;
        }

        public int getNextIndex() {
            return this.m_nNext;
        }

        public List<Binary> getElements() {
            return this.m_listElements == null ? Collections.emptyList() : this.m_listElements;
        }

        @Override
        public int getImplVersion() {
            return 1;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_cElementsRemaining = in.readInt(0);
            this.m_nNext = in.readInt(1);
            this.m_listElements = in.readCollection(2, new ArrayList());
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_cElementsRemaining);
            out.writeInt(1, this.m_nNext);
            out.writeCollection(2, this.m_listElements, Binary.class);
        }

        public String toString() {
            return "TopicPollResult(remaining=" + this.m_cElementsRemaining + ", next=" + this.m_nNext + ", retrieved=" + this.m_listElements + ')';
        }
    }
}

