/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind;

import com.tangosol.internal.sleepycat.bind.EntryBinding;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;

public class ByteArrayBinding
implements EntryBinding<byte[]> {
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    @Override
    public byte[] entryToObject(DatabaseEntry entry) {
        int len = entry.getSize();
        if (len == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] bytes = new byte[len];
        System.arraycopy(entry.getData(), entry.getOffset(), bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public void objectToEntry(byte[] object, DatabaseEntry entry) {
        entry.setData(object, 0, object.length);
    }
}

