/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind.tuple;

import com.tangosol.internal.sleepycat.bind.tuple.MarshalledTupleEntry;
import com.tangosol.internal.sleepycat.bind.tuple.TupleBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleInput;
import com.tangosol.internal.sleepycat.bind.tuple.TupleOutput;
import com.tangosol.internal.sleepycat.util.RuntimeExceptionWrapper;

public class TupleMarshalledBinding<E extends MarshalledTupleEntry>
extends TupleBinding<E> {
    private Class<E> cls;

    public TupleMarshalledBinding(Class<E> cls) {
        this.cls = cls;
        if (!MarshalledTupleEntry.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.toString() + " does not implement MarshalledTupleEntry");
        }
    }

    @Override
    public E entryToObject(TupleInput input) {
        try {
            MarshalledTupleEntry obj = (MarshalledTupleEntry)this.cls.newInstance();
            obj.unmarshalEntry(input);
            return (E)obj;
        }
        catch (IllegalAccessException e) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(e);
        }
        catch (InstantiationException e) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(e);
        }
    }

    @Override
    public void objectToEntry(E object, TupleOutput output) {
        object.marshalEntry(output);
    }
}

