/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je;

import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DiskOrderedCursorConfig;
import com.tangosol.internal.sleepycat.je.ForwardCursor;
import com.tangosol.internal.sleepycat.je.LockMode;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DbiStatDefinition;
import com.tangosol.internal.sleepycat.je.dbi.DiskOrderedCursorImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.utilint.AtomicLongStat;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskOrderedCursor
implements ForwardCursor {
    private final Database dbHandle;
    private final DatabaseImpl dbImpl;
    private final DiskOrderedCursorConfig config;
    private final DiskOrderedCursorImpl dosCursorImpl;
    private AtomicLongStat getNextStat;
    private final Logger logger;

    DiskOrderedCursor(Database dbHandle, DiskOrderedCursorConfig config) {
        this.dbHandle = dbHandle;
        this.config = config;
        this.dbImpl = dbHandle.getDatabaseImpl();
        this.dosCursorImpl = new DiskOrderedCursorImpl(this.dbImpl, config);
        dbHandle.addCursor(this);
        this.logger = this.dbImpl.getEnv().getLogger();
        this.setupThroughputStats(this.dbImpl.getEnv());
    }

    @Override
    public Database getDatabase() {
        return this.dbHandle;
    }

    @Override
    public void close() throws DatabaseException {
        if (this.dosCursorImpl.isClosed()) {
            return;
        }
        try {
            this.dosCursorImpl.checkEnv();
            this.dosCursorImpl.close();
            this.dbHandle.removeCursor(this);
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        try {
            this.checkState();
            Cursor.checkArgsNoValRequired(key, data);
            this.checkLockMode(lockMode);
            this.trace(Level.FINEST, "DiskOrderedCursor.getCurrent: ", lockMode);
            return this.dosCursorImpl.getCurrent(key, data);
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        try {
            this.checkState();
            Cursor.checkArgsNoValRequired(key, data);
            this.checkLockMode(lockMode);
            this.trace(Level.FINEST, "DiskOrderedCursor.getNext: ", lockMode);
            this.getNextStat.increment();
            return this.dosCursorImpl.getNext(key, data);
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    public DiskOrderedCursorConfig getConfig() {
        try {
            return this.config.clone();
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    private void checkLockMode(LockMode lockMode) {
        if (lockMode == null || lockMode == LockMode.READ_UNCOMMITTED) {
            return;
        }
        throw new IllegalArgumentException("lockMode must be null or LockMode.READ_UNCOMMITTED");
    }

    private void checkState() {
        this.dosCursorImpl.checkEnv();
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't call ForwardCursor method:");
        }
    }

    private void trace(Level level, String methodName, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getEnv(), level, sb.toString());
        }
    }

    private void setupThroughputStats(EnvironmentImpl envImpl) {
        this.getNextStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DOSCURSOR_GETNEXT);
    }

    DiskOrderedCursorImpl getCursorImpl() {
        return this.dosCursorImpl;
    }
}

