/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.cleaner;

import com.tangosol.internal.sleepycat.je.cleaner.Cleaner;
import com.tangosol.internal.sleepycat.je.cleaner.DbFileSummary;
import com.tangosol.internal.sleepycat.je.cleaner.DbFileSummaryMap;
import com.tangosol.internal.sleepycat.je.cleaner.TrackedFileSummary;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseUtilizationTracker {
    EnvironmentImpl env;
    Cleaner cleaner;
    private long activeFile;
    volatile long bytesSinceActivate;
    private volatile Map<Long, TrackedFileSummary> fileSummaries;

    BaseUtilizationTracker(EnvironmentImpl env, Cleaner cleaner) {
        assert (cleaner != null);
        this.env = env;
        this.cleaner = cleaner;
        this.fileSummaries = new HashMap<Long, TrackedFileSummary>();
        this.activeFile = -1L;
    }

    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    public Collection<TrackedFileSummary> getTrackedFiles() {
        return this.fileSummaries.values();
    }

    public TrackedFileSummary getTrackedFile(long fileNum) {
        return this.fileSummaries.get(fileNum);
    }

    final boolean countNew(long lsn, Object databaseKey, LogEntryType type, int size) {
        assert (type != null);
        long fileNum = DbLsn.getFileNumber(lsn);
        TrackedFileSummary fileSummary = this.getFileSummary(fileNum);
        ++fileSummary.totalCount;
        fileSummary.totalSize += size;
        boolean isLN = BaseUtilizationTracker.isLNType(type);
        if (isLN && fileSummary.maxLNSize < size) {
            fileSummary.maxLNSize = size;
        }
        if (BaseUtilizationTracker.trackObsoleteInfo(type)) {
            assert (databaseKey != null) : "No DB for lsn=" + DbLsn.getNoFormatString(lsn) + " type: " + type;
            DbFileSummary dbFileSummary = this.getDbFileSummary(databaseKey, fileNum);
            if (isLN) {
                ++fileSummary.totalLNCount;
                fileSummary.totalLNSize += size;
                if (dbFileSummary != null) {
                    ++dbFileSummary.totalLNCount;
                    dbFileSummary.totalLNSize += size;
                }
            } else {
                ++fileSummary.totalINCount;
                fileSummary.totalINSize += size;
                if (dbFileSummary != null) {
                    ++dbFileSummary.totalINCount;
                    dbFileSummary.totalINSize += size;
                }
            }
        }
        this.bytesSinceActivate += (long)size;
        return this.bytesSinceActivate >= this.cleaner.cleanerBytesInterval;
    }

    final void countObsolete(long lsn, Object databaseKey, LogEntryType type, int size, boolean countPerFile, boolean countPerDb, boolean trackOffset, boolean checkDupOffsets) {
        assert (BaseUtilizationTracker.trackObsoleteInfo(type));
        boolean isLN = BaseUtilizationTracker.isLNType(type);
        long fileNum = DbLsn.getFileNumber(lsn);
        if (countPerFile) {
            long offset;
            TrackedFileSummary fileSummary = this.getFileSummary(fileNum);
            if (isLN) {
                ++fileSummary.obsoleteLNCount;
                if (size > 0) {
                    fileSummary.obsoleteLNSize += size;
                    ++fileSummary.obsoleteLNSizeCounted;
                }
            } else {
                ++fileSummary.obsoleteINCount;
                assert (size == 0);
            }
            if (trackOffset && (offset = DbLsn.getFileOffset(lsn)) != 0L) {
                fileSummary.trackObsolete(offset, checkDupOffsets);
            }
        }
        if (countPerDb) {
            assert (databaseKey != null) : "No DB for lsn=" + DbLsn.getNoFormatString(lsn) + " type: " + type;
            DbFileSummary dbFileSummary = this.getDbFileSummary(databaseKey, fileNum);
            if (dbFileSummary != null) {
                if (isLN) {
                    ++dbFileSummary.obsoleteLNCount;
                    if (size > 0) {
                        dbFileSummary.obsoleteLNSize += size;
                        ++dbFileSummary.obsoleteLNSizeCounted;
                    }
                } else {
                    ++dbFileSummary.obsoleteINCount;
                    assert (size == 0);
                }
            }
        }
    }

    public void countObsoleteDb(DbFileSummaryMap dbFileSummaries, long mapLnLsn) {
        for (Map.Entry<Long, DbFileSummary> entry : dbFileSummaries.entrySet()) {
            Long fileNum = entry.getKey();
            if (!this.isFileUncounted(fileNum, mapLnLsn)) continue;
            DbFileSummary dbFileSummary = entry.getValue();
            TrackedFileSummary fileSummary = this.getFileSummary(fileNum);
            int lnObsoleteCount = dbFileSummary.totalLNCount - dbFileSummary.obsoleteLNCount;
            int lnObsoleteSize = dbFileSummary.totalLNSize - dbFileSummary.obsoleteLNSize;
            int inObsoleteCount = dbFileSummary.totalINCount - dbFileSummary.obsoleteINCount;
            fileSummary.obsoleteLNCount += lnObsoleteCount;
            fileSummary.obsoleteLNSize += lnObsoleteSize;
            fileSummary.obsoleteINCount += inObsoleteCount;
            int lnObsoleteSizeCounted = lnObsoleteCount + (dbFileSummary.obsoleteLNCount - dbFileSummary.obsoleteLNSizeCounted);
            fileSummary.obsoleteLNSizeCounted += lnObsoleteSizeCounted;
        }
    }

    boolean isFileUncounted(Long fileNum, long lsn) {
        return true;
    }

    abstract DbFileSummary getDbFileSummary(Object var1, long var2);

    TrackedFileSummary getFileSummary(long fileNum) {
        Long fileNumLong;
        TrackedFileSummary file;
        if (this.activeFile < fileNum) {
            this.activeFile = fileNum;
        }
        if ((file = this.fileSummaries.get(fileNumLong = Long.valueOf(fileNum))) == null) {
            file = new TrackedFileSummary(this, fileNum, this.cleaner.trackDetail);
            HashMap<Long, TrackedFileSummary> newFiles = new HashMap<Long, TrackedFileSummary>(this.fileSummaries);
            newFiles.put(fileNumLong, file);
            this.fileSummaries = newFiles;
        }
        return file;
    }

    void resetFile(TrackedFileSummary fileSummary) {
        if (fileSummary.getFileNumber() < this.activeFile && fileSummary.getAllowFlush()) {
            HashMap<Long, TrackedFileSummary> newFiles = new HashMap<Long, TrackedFileSummary>(this.fileSummaries);
            newFiles.remove(fileSummary.getFileNumber());
            this.fileSummaries = newFiles;
        }
    }

    public static boolean trackObsoleteInfo(LogEntryType type) {
        return type == null || type.isNodeType() || type.equals(LogEntryType.LOG_BIN_DELTA) || type.equals(LogEntryType.LOG_OLD_BIN_DELTA);
    }

    public static boolean isLNType(LogEntryType type) {
        return type == null || type.isLNType();
    }

    void close() {
        for (TrackedFileSummary t : this.fileSummaries.values()) {
            t.close();
        }
    }
}

