/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.latch;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.ThreadInterruptedException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.latch.Latch;
import com.tangosol.internal.sleepycat.je.latch.LatchContext;
import com.tangosol.internal.sleepycat.je.latch.LatchStatDefinition;
import com.tangosol.internal.sleepycat.je.latch.LatchSupport;
import com.tangosol.internal.sleepycat.je.latch.OwnerInfo;
import com.tangosol.internal.sleepycat.je.utilint.IntStat;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class LatchWithStatsImpl
extends ReentrantLock
implements Latch {
    private final LatchContext context;
    private OwnerInfo lastOwnerInfo;
    private final StatGroup stats;
    private final IntStat nAcquiresNoWaiters;
    private final IntStat nAcquiresSelfOwned;
    private final IntStat nAcquiresWithContention;
    private final IntStat nAcquiresNoWaitSuccessful;
    private final IntStat nAcquiresNoWaitUnsuccessful;
    private final IntStat nReleases;

    LatchWithStatsImpl(LatchContext context) {
        this.context = context;
        this.stats = new StatGroup("Latch", "Latch characteristics");
        this.nAcquiresNoWaiters = new IntStat(this.stats, LatchStatDefinition.LATCH_NO_WAITERS);
        this.nAcquiresSelfOwned = new IntStat(this.stats, LatchStatDefinition.LATCH_SELF_OWNED);
        this.nAcquiresWithContention = new IntStat(this.stats, LatchStatDefinition.LATCH_CONTENTION);
        this.nAcquiresNoWaitSuccessful = new IntStat(this.stats, LatchStatDefinition.LATCH_NOWAIT_SUCCESS);
        this.nAcquiresNoWaitUnsuccessful = new IntStat(this.stats, LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS);
        this.nReleases = new IntStat(this.stats, LatchStatDefinition.LATCH_RELEASES);
    }

    String getName() {
        return this.context.getLatchName();
    }

    @Override
    public void acquireExclusive() {
        if (this.isHeldByCurrentThread()) {
            this.nAcquiresSelfOwned.increment();
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held: " + this.debugString());
        }
        if (this.isLocked()) {
            this.nAcquiresWithContention.increment();
        } else {
            this.nAcquiresNoWaiters.increment();
        }
        try {
            if (!this.tryLock(this.context.getLatchTimeoutMs(), TimeUnit.MILLISECONDS)) {
                throw LatchSupport.handleTimeout(this, this.context);
            }
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.context.getEnvImplForFatalException(), (Throwable)e);
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackAcquire(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = new OwnerInfo(this.context);
        }
        assert (EnvironmentImpl.maybeForceYield());
    }

    @Override
    public boolean acquireExclusiveNoWait() {
        if (this.isHeldByCurrentThread()) {
            this.nAcquiresSelfOwned.increment();
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held: " + this.debugString());
        }
        if (!this.tryLock()) {
            this.nAcquiresNoWaitUnsuccessful.increment();
            return false;
        }
        this.nAcquiresNoWaitSuccessful.increment();
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackAcquire(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = new OwnerInfo(this.context);
        }
        assert (EnvironmentImpl.maybeForceYield());
        return true;
    }

    @Override
    public void release() {
        if (!this.isHeldByCurrentThread()) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch not held: " + this.debugString());
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackRelease(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = null;
        }
        this.unlock();
        this.nReleases.increment();
    }

    @Override
    public void releaseIfOwner() {
        if (!this.isHeldByCurrentThread()) {
            return;
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackRelease(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = null;
        }
        this.unlock();
        this.nReleases.increment();
    }

    @Override
    public boolean isOwner() {
        return this.isHeldByCurrentThread();
    }

    @Override
    public boolean isExclusiveOwner() {
        return this.isHeldByCurrentThread();
    }

    @Override
    public Thread getExclusiveOwner() {
        return this.getOwner();
    }

    @Override
    public int getNWaiters() {
        return this.getQueueLength();
    }

    @Override
    public StatGroup getStats() {
        return this.stats;
    }

    @Override
    public void clearStats() {
        this.stats.clear();
    }

    @Override
    public String toString() {
        return LatchSupport.toString(this, this.context, this.lastOwnerInfo);
    }

    @Override
    public String debugString() {
        return LatchSupport.debugString(this, this.context, this.lastOwnerInfo);
    }
}

