/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log;

import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import com.tangosol.internal.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.tangosol.internal.sleepycat.je.log.ReplicationContext;
import com.tangosol.internal.sleepycat.je.log.entry.DbOperationType;
import com.tangosol.internal.sleepycat.je.log.entry.NameLNLogEntry;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;

public class DbOpReplicationContext
extends ReplicationContext {
    public static DbOpReplicationContext NO_REPLICATE = new DbOpReplicationContext(false, DbOperationType.NONE);
    private final DbOperationType opType;
    private ReplicatedDatabaseConfig createConfig = null;
    private DatabaseId truncateOldDbId = null;

    public DbOpReplicationContext(boolean inReplicationStream, DbOperationType opType) {
        super(inReplicationStream);
        this.opType = opType;
    }

    public DbOpReplicationContext(VLSN vlsn, NameLNLogEntry nameLNEntry) {
        super(vlsn);
        this.opType = nameLNEntry.getOperationType();
        if (DbOperationType.isWriteConfigType(this.opType)) {
            this.createConfig = nameLNEntry.getReplicatedCreateConfig();
        } else if (this.opType == DbOperationType.TRUNCATE) {
            this.truncateOldDbId = nameLNEntry.getTruncateOldDbId();
        }
    }

    @Override
    public DbOperationType getDbOperationType() {
        return this.opType;
    }

    public void setCreateConfig(ReplicatedDatabaseConfig createConfig) {
        assert (DbOperationType.isWriteConfigType(this.opType));
        this.createConfig = createConfig;
    }

    public ReplicatedDatabaseConfig getCreateConfig() {
        assert (DbOperationType.isWriteConfigType(this.opType));
        return this.createConfig;
    }

    public void setTruncateOldDbId(DatabaseId truncateOldDbId) {
        assert (this.opType == DbOperationType.TRUNCATE);
        this.truncateOldDbId = truncateOldDbId;
    }

    public DatabaseId getTruncateOldDbId() {
        assert (this.opType == DbOperationType.TRUNCATE);
        return this.truncateOldDbId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("opType=").append(this.opType);
        sb.append("truncDbId=").append(this.truncateOldDbId);
        return sb.toString();
    }
}

