/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log.entry;

import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.LogEntryHeader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import com.tangosol.internal.sleepycat.je.log.entry.BaseEntry;
import com.tangosol.internal.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

public class SingleItemEntry<T extends Loggable>
extends BaseEntry<T>
implements LogEntry {
    private T item;

    public static <T extends Loggable> SingleItemEntry<T> create(Class<T> logClass) {
        return new SingleItemEntry<T>(logClass);
    }

    SingleItemEntry(Class<T> logClass) {
        super(logClass);
    }

    public static <T extends Loggable> SingleItemEntry<T> create(LogEntryType entryType, T item) {
        return new SingleItemEntry<T>(entryType, item);
    }

    public SingleItemEntry(LogEntryType entryType, T item) {
        this.setLogType(entryType);
        this.item = item;
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        this.item = this.newInstanceOfType();
        this.item.readFromLog(entryBuffer, header.getVersion());
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.item.dumpLog(sb, verbose);
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }

    public T getMainItem() {
        return this.item;
    }

    @Override
    public long getTransactionId() {
        return this.item.getTransactionId();
    }

    @Override
    public DatabaseId getDbId() {
        return null;
    }

    @Override
    public int getSize() {
        return this.item.getLogSize();
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.item.writeToLog(destBuffer);
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return this.item.logicalEquals((Loggable)other.getMainItem());
    }
}

