/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl.node;

import com.tangosol.internal.sleepycat.je.rep.NodeType;
import com.tangosol.internal.sleepycat.je.rep.QuorumPolicy;
import com.tangosol.internal.sleepycat.je.rep.arbitration.Arbiter;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.impl.node.FeederManager;
import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.rep.stream.MasterStatus;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Logger;

public class ElectionQuorum {
    private final RepImpl repImpl;
    private final Logger logger;
    private volatile int electableGroupSizeOverride;

    public ElectionQuorum(RepImpl repImpl) {
        this.repImpl = repImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.electableGroupSizeOverride = repImpl.getConfigManager().getInt(RepParams.ELECTABLE_GROUP_SIZE_OVERRIDE);
        if (this.electableGroupSizeOverride > 0) {
            LoggerUtils.warning(this.logger, repImpl, "Electable group size override set to:" + this.electableGroupSizeOverride);
        }
    }

    public ElectionQuorum() {
        this.repImpl = null;
        this.logger = null;
    }

    public void setElectableGroupSizeOverride(int override) {
        if (this.electableGroupSizeOverride != override) {
            LoggerUtils.warning(this.logger, this.repImpl, "Electable group size override changed to:" + override);
        }
        this.electableGroupSizeOverride = override;
    }

    int getElectableGroupSizeOverride() {
        return this.electableGroupSizeOverride;
    }

    public boolean haveQuorum(QuorumPolicy quorumPolicy, int votes) {
        return votes >= this.getElectionQuorumSize(quorumPolicy);
    }

    boolean isAuthoritativeMaster(MasterStatus masterStatus, FeederManager feederManager) {
        if (!masterStatus.isGroupMaster()) {
            return false;
        }
        return feederManager.activeReplicaCount() + 1 >= this.getElectionQuorumSize(QuorumPolicy.SIMPLE_MAJORITY);
    }

    private int getElectionQuorumSize(QuorumPolicy quorumPolicy) {
        if (this.electableGroupSizeOverride > 0) {
            return quorumPolicy.quorumSize(this.electableGroupSizeOverride);
        }
        RepNode repNode = this.repImpl.getRepNode();
        Arbiter arbiter = repNode.getArbiter();
        if (arbiter.isApplicable(quorumPolicy)) {
            return arbiter.getElectionQuorumSize(quorumPolicy);
        }
        return quorumPolicy.quorumSize(repNode.getGroup().getElectableGroupSize());
    }

    public boolean nodeTypeParticipates(NodeType nodeType) {
        return nodeType.isElectable();
    }
}

