/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl.node;

import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.util.Timer;
import java.util.TimerTask;

class LogFlusher {
    private final RepNode repNode;
    private final Timer timer;
    private int flushInterval;
    private LogFlushTask flushTask;

    public LogFlusher(RepNode repNode, Timer timer) {
        this.repNode = repNode;
        this.timer = timer;
    }

    public void configFlushTask(int interval) {
        if (this.flushInterval == interval && this.flushTask != null) {
            return;
        }
        this.flushInterval = interval;
        this.cancelTask();
        this.flushTask = new LogFlushTask(this.repNode);
        this.timer.schedule((TimerTask)this.flushTask, 0L, (long)this.flushInterval);
    }

    public void cancelTask() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
            this.flushTask = null;
        }
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public LogFlushTask getFlushTask() {
        return this.flushTask;
    }

    static class LogFlushTask
    extends TimerTask {
        private final RepNode repNode;
        private VLSN lastTxnEndVLSN;

        public LogFlushTask(RepNode repNode) {
            this.repNode = repNode;
            this.lastTxnEndVLSN = repNode.getCurrentTxnEndVLSN();
        }

        @Override
        public void run() {
            VLSN newTxnEndVLSN = this.repNode.getCurrentTxnEndVLSN();
            if (newTxnEndVLSN == null) {
                return;
            }
            if (this.lastTxnEndVLSN == null || newTxnEndVLSN.compareTo(this.lastTxnEndVLSN) == 1) {
                this.lastTxnEndVLSN = newTxnEndVLSN;
                this.repNode.getRepImpl().getLogManager().flush();
            }
        }
    }
}

