/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.stream;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.ChecksumException;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.node.Feeder;
import com.tangosol.internal.sleepycat.je.rep.impl.node.LocalCBVLSNUpdater;
import com.tangosol.internal.sleepycat.je.rep.impl.node.NameIdPair;
import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.rep.stream.FeederSyncupReader;
import com.tangosol.internal.sleepycat.je.rep.stream.OutputWireRecord;
import com.tangosol.internal.sleepycat.je.rep.stream.Protocol;
import com.tangosol.internal.sleepycat.je.rep.utilint.BinaryProtocol;
import com.tangosol.internal.sleepycat.je.rep.utilint.NamedChannel;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNIndex;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNRange;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeederReplicaSyncup {
    private final Feeder feeder;
    private final RepNode repNode;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final VLSNIndex vlsnIndex;
    private final Logger logger;
    private FeederSyncupReader backwardsReader;

    public FeederReplicaSyncup(Feeder feeder, NamedChannel namedChannel, Protocol protocol) {
        this.feeder = feeder;
        this.repNode = feeder.getRepNode();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.vlsnIndex = this.repNode.getVLSNIndex();
    }

    public VLSN execute(LocalCBVLSNUpdater replicaCBVLSN) throws DatabaseException, IOException, NetworkRestoreException, ChecksumException {
        VLSN vLSN;
        long startTime = System.currentTimeMillis();
        RepImpl repImpl = this.repNode.getRepImpl();
        LoggerUtils.info(this.logger, repImpl, "Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " syncup started. Feeder range: " + this.repNode.getVLSNIndex().getRange());
        this.repNode.syncupStarted();
        try {
            BinaryProtocol.Message message;
            VLSN startVLSN;
            block8: {
                VLSNRange range = this.vlsnIndex.getRange();
                Protocol.EntryRequest firstRequest = (Protocol.EntryRequest)this.protocol.read(this.namedChannel);
                BinaryProtocol.Message response = this.makeResponseToEntryRequest(range, firstRequest, true);
                this.protocol.write(response, this.namedChannel);
                startVLSN = null;
                while (true) {
                    message = this.protocol.read(this.namedChannel);
                    if (this.logger.isLoggable(Level.FINEST)) {
                        LoggerUtils.finest(this.logger, repImpl, "Replica " + this.feeder.getReplicaNameIdPair() + " message op: " + message.getOp());
                    }
                    if (message instanceof Protocol.StartStream) break block8;
                    if (!(message instanceof Protocol.EntryRequest)) break;
                    response = this.makeResponseToEntryRequest(range, (Protocol.EntryRequest)message, false);
                    this.protocol.write(response, this.namedChannel);
                }
                if (message instanceof Protocol.RestoreRequest) {
                    throw this.answerRestore(range, ((Protocol.RestoreRequest)message).getVLSN());
                }
                throw EnvironmentFailureException.unexpectedState(repImpl, "Expected StartStream or EntryRequest but got " + message);
            }
            startVLSN = ((Protocol.StartStream)message).getVLSN();
            LoggerUtils.info(this.logger, repImpl, "Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " start stream at VLSN: " + startVLSN);
            vLSN = startVLSN;
            this.repNode.syncupEnded();
        }
        catch (NetworkRestoreException e) {
            try {
                if (replicaCBVLSN != null) {
                    replicaCBVLSN.updateForReplica(this.repNode.getGroupCBVLSN());
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.repNode.syncupEnded();
                LoggerUtils.info(this.logger, repImpl, String.format("Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
                throw throwable;
            }
        }
        LoggerUtils.info(this.logger, repImpl, String.format("Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
        return vLSN;
    }

    private FeederSyncupReader setupReader(VLSN startVLSN) throws DatabaseException, IOException {
        RepImpl envImpl = this.repNode.getRepImpl();
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        long lastUsedLsn = envImpl.getFileManager().getLastUsedLsn();
        long finishLsn = DbLsn.makeLsn(this.repNode.getCleanerBarrierFile(), 0);
        return new FeederSyncupReader((EnvironmentImpl)envImpl, this.vlsnIndex, lastUsedLsn, readBufferSize, this.repNode.getNameIdPair(), startVLSN, finishLsn);
    }

    private BinaryProtocol.Message makeResponseToEntryRequest(VLSNRange range, Protocol.EntryRequest request, boolean isFirstResponse) throws IOException, ChecksumException {
        OutputWireRecord matchRecord;
        VLSN requestMatchpoint = request.getVLSN();
        VLSN globalCBVLSN = this.repNode.getGroupCBVLSN();
        if (globalCBVLSN.isNull() ? range.getFirst().compareTo(requestMatchpoint) > 0 : globalCBVLSN.compareTo(requestMatchpoint) > 0) {
            return new Protocol.EntryNotFound(this.protocol);
        }
        if (!globalCBVLSN.isNull() && range.getFirst().compareTo(globalCBVLSN) > 0) {
            throw EnvironmentFailureException.unexpectedState("Range " + range + " precedes globalCBVLSN " + globalCBVLSN);
        }
        if (range.getLast().compareTo(requestMatchpoint) < 0) {
            assert (this.backwardsReader == null) : "Replica request for vlsn > feeder range should only happen on the first exchange.";
            if (range.getLastSync().equals(VLSN.NULL_VLSN)) {
                return new Protocol.EntryNotFound(this.protocol);
            }
            if (isFirstResponse) {
                this.backwardsReader = this.setupReader(range.getLastSync());
                OutputWireRecord lastSync = this.backwardsReader.scanBackwards(range.getLastSync());
                assert (lastSync != null) : "Look for alternative, range=" + range;
                Protocol protocol = this.protocol;
                protocol.getClass();
                return new Protocol.AlternateMatchpoint(protocol, lastSync);
            }
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "RequestMatchpoint=" + requestMatchpoint + " range=" + range + "should only happen on first response");
        }
        if (this.backwardsReader == null) {
            this.backwardsReader = this.setupReader(requestMatchpoint);
        }
        if ((matchRecord = this.backwardsReader.scanBackwards(requestMatchpoint)) == null) {
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Couldn't find matchpoint " + requestMatchpoint + " in log. VLSN range=" + range + " globalCBVLSN=" + globalCBVLSN);
        }
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Entry(protocol, matchRecord);
    }

    private NetworkRestoreException answerRestore(VLSNRange range, VLSN failedMatchpoint) throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        Protocol.RestoreResponse response = new Protocol.RestoreResponse(protocol, this.repNode.getGroupCBVLSN(), this.repNode.getLogProviders());
        this.protocol.write((BinaryProtocol.Message)response, this.namedChannel);
        return new NetworkRestoreException(failedMatchpoint, range.getFirst(), range.getLast(), this.feeder.getReplicaNameIdPair());
    }

    public static class NetworkRestoreException
    extends Exception {
        private final VLSN vlsn;
        private final VLSN firstVLSN;
        private final VLSN lastVLSN;
        private final NameIdPair replicaNameIdPair;

        public NetworkRestoreException(VLSN vlsn, VLSN firstVLSN, VLSN lastVLSN, NameIdPair replicaNameIdPair) {
            this.vlsn = vlsn;
            this.firstVLSN = firstVLSN;
            this.lastVLSN = lastVLSN;
            this.replicaNameIdPair = replicaNameIdPair;
        }

        @Override
        public String getMessage() {
            return "Matchpoint vlsn " + this.vlsn + " requested by node: " + this.replicaNameIdPair + " was outside the VLSN range: " + "[" + this.firstVLSN + "-" + this.lastVLSN + "]";
        }

        public VLSN getVlsn() {
            return this.vlsn;
        }

        public NameIdPair getReplicaNameIdPair() {
            return this.replicaNameIdPair;
        }
    }
}

